/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.io;

import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.io.InputSupplier;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

class MultiReader
extends Reader {
    private final Iterator<? extends InputSupplier<? extends Reader>> it;
    private Reader current;

    MultiReader(Iterator<? extends InputSupplier<? extends Reader>> readers) throws IOException {
        this.it = readers;
        this.advance();
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.current = this.it.next().getInput();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.current == null) {
            return -1;
        }
        int n2 = this.current.read(cbuf, off, len);
        if (n2 == -1) {
            this.advance();
            return this.read(cbuf, off, len);
        }
        return n2;
    }

    @Override
    public long skip(long n2) throws IOException {
        Preconditions.checkArgument(n2 >= 0L, "n is negative");
        if (n2 > 0L) {
            while (this.current != null) {
                long l2 = this.current.skip(n2);
                if (l2 > 0L) {
                    return l2;
                }
                this.advance();
            }
        }
        return 0L;
    }

    @Override
    public boolean ready() throws IOException {
        return this.current != null && this.current.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.current != null) {
            try {
                this.current.close();
            }
            finally {
                this.current = null;
            }
        }
    }
}

