/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.util.concurrent;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.ObjectArrays;
import com.timevale.guava.common.collect.Sets;
import com.timevale.guava.common.util.concurrent.TimeLimiter;
import com.timevale.guava.common.util.concurrent.UncheckedTimeoutException;
import com.timevale.guava.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
public final class SimpleTimeLimiter
implements TimeLimiter {
    private final ExecutorService executor;

    public SimpleTimeLimiter(ExecutorService executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    public SimpleTimeLimiter() {
        this(Executors.newCachedThreadPool());
    }

    @Override
    public <T> T newProxy(final T target, Class<T> interfaceType, final long timeoutDuration, final TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        Preconditions.checkArgument(timeoutDuration > 0L, "bad timeout: " + timeoutDuration);
        Preconditions.checkArgument(interfaceType.isInterface(), "interfaceType must be an interface type");
        final Set<Method> set = SimpleTimeLimiter.findInterruptibleMethods(interfaceType);
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, final Method method, final Object[] args) throws Throwable {
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            return method.invoke(target, args);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            SimpleTimeLimiter.throwCause(invocationTargetException, false);
                            throw new AssertionError((Object)"can't get here");
                        }
                    }
                };
                return SimpleTimeLimiter.this.callWithTimeout(callable, timeoutDuration, timeoutUnit, set.contains(method));
            }
        };
        return SimpleTimeLimiter.newProxy(interfaceType, invocationHandler);
    }

    @Override
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit, boolean amInterruptible) throws Exception {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        Preconditions.checkArgument(timeoutDuration > 0L, "timeout must be positive: %s", timeoutDuration);
        Future<T> future = this.executor.submit(callable);
        try {
            if (amInterruptible) {
                try {
                    return future.get(timeoutDuration, timeoutUnit);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    throw interruptedException;
                }
            }
            return Uninterruptibles.getUninterruptibly(future, timeoutDuration, timeoutUnit);
        }
        catch (ExecutionException executionException) {
            throw SimpleTimeLimiter.throwCause(executionException, true);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw new UncheckedTimeoutException(timeoutException);
        }
    }

    private static Exception throwCause(Exception e2, boolean combineStackTraces) throws Exception {
        Throwable throwable = e2.getCause();
        if (throwable == null) {
            throw e2;
        }
        if (combineStackTraces) {
            StackTraceElement[] stackTraceElementArray = ObjectArrays.concat(throwable.getStackTrace(), e2.getStackTrace(), StackTraceElement.class);
            throwable.setStackTrace(stackTraceElementArray);
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw e2;
    }

    private static Set<Method> findInterruptibleMethods(Class<?> interfaceType) {
        HashSet<Method> hashSet = Sets.newHashSet();
        for (Method method : interfaceType.getMethods()) {
            if (!SimpleTimeLimiter.declaresInterruptedEx(method)) continue;
            hashSet.add(method);
        }
        return hashSet;
    }

    private static boolean declaresInterruptedEx(Method method) {
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (clazz != InterruptedException.class) continue;
            return true;
        }
        return false;
    }

    private static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }
}

