/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.request.generator.impl;

import com.timevale.seal.sdk.drawer.request.InnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.DoubleEllipseInnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.SurroundTextInfo;
import com.timevale.seal.sdk.enums.DrawRuleTypeEnum;
import com.timevale.seal.sdk.enums.UnitEnum;
import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.request.DoubleEllipseSealRequest;
import com.timevale.seal.sdk.request.SealBaseRequest;
import com.timevale.seal.sdk.request.generator.impl.EllipseImageRequestGenerator;
import com.timevale.seal.sdk.util.FontUtil;
import com.timevale.seal.sdk.util.PixelUtil;
import com.timevale.seal.sdk.util.StringUtils;
import java.awt.Font;

public class DoubleEllipseImageRequestGenerator
extends EllipseImageRequestGenerator {
    @Override
    protected InnerRequest getImageRequest() {
        return new DoubleEllipseInnerRequest();
    }

    @Override
    protected <T extends SealBaseRequest> void validateRequest(T t2) {
        super.validateRequest(t2);
        DoubleEllipseSealRequest doubleEllipseSealRequest = (DoubleEllipseSealRequest)t2;
        String string = doubleEllipseSealRequest.getInnerTopSurroundText();
        if (StringUtils.isNotBlank(string) && null == doubleEllipseSealRequest.getInnerTopSurroundTextFont()) {
            throw new SealSdkException("\u5185\u90e8\u73af\u7ed5\u6587\u5b57\u4f53\u4e3a\u7a7a");
        }
        int n2 = doubleEllipseSealRequest.getInnerWidth();
        if (n2 <= 0) {
            throw new SealSdkException("\u5185\u5706\u5bbd\u5ea6\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        int n3 = doubleEllipseSealRequest.getInnerHeight();
        if (n3 <= 0) {
            throw new SealSdkException("\u5185\u5706\u9ad8\u5ea6\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        float f2 = doubleEllipseSealRequest.getInnerBorderWidth();
        if (f2 < 0.0f) {
            throw new SealSdkException("\u5185\u8fb9\u5bbd\u4e3a\u7a7a");
        }
    }

    @Override
    protected <T extends SealBaseRequest, R extends InnerRequest> void convertDetail(T t2, R r2) {
        super.convertDetail(t2, r2);
        DoubleEllipseSealRequest doubleEllipseSealRequest = (DoubleEllipseSealRequest)t2;
        DoubleEllipseInnerRequest doubleEllipseInnerRequest = (DoubleEllipseInnerRequest)r2;
        if (UnitEnum.MM.equals((Object)doubleEllipseSealRequest.getUnit())) {
            doubleEllipseInnerRequest.setInnerWidth(PixelUtil.transferMmToPixel(doubleEllipseSealRequest.getInnerWidth(), doubleEllipseSealRequest.getSealTypeEnum().getDpi()));
            doubleEllipseInnerRequest.setInnerHeight(PixelUtil.transferMmToPixel(doubleEllipseSealRequest.getInnerHeight(), doubleEllipseSealRequest.getSealTypeEnum().getDpi()));
            doubleEllipseInnerRequest.setInnerBorderWidth(PixelUtil.transferMmToPixel(doubleEllipseSealRequest.getInnerBorderWidth(), doubleEllipseSealRequest.getSealTypeEnum().getDpi()));
        } else {
            doubleEllipseInnerRequest.setInnerWidth(doubleEllipseSealRequest.getInnerWidth());
            doubleEllipseInnerRequest.setInnerHeight(doubleEllipseSealRequest.getInnerHeight());
            doubleEllipseInnerRequest.setInnerBorderWidth((int)doubleEllipseSealRequest.getInnerBorderWidth());
        }
        String string = doubleEllipseSealRequest.getInnerTopSurroundText();
        if (StringUtils.isNotBlank(string)) {
            SurroundTextInfo surroundTextInfo = new SurroundTextInfo();
            surroundTextInfo.setText(string);
            surroundTextInfo.setFont(this.getInnerTopSurroundTextFont(string.length(), doubleEllipseSealRequest.getInnerTopSurroundTextFont()));
            surroundTextInfo.setScaleX(this.getInnerTopSurroundTextScaleX(string.length()));
            surroundTextInfo.setArcAng(250);
            surroundTextInfo.setMinRat(0.2f);
            doubleEllipseInnerRequest.setInnerTopSurroundTextInfo(surroundTextInfo);
        }
    }

    @Override
    protected int getTopSurroundFontSize(int width, int height, int length, DrawRuleTypeEnum drawRuleTypeEnum) {
        int n2 = 62;
        int n3 = 35;
        if (length > n3) {
            n2 = length <= 40 ? (n2 -= length - n3) : (n2 -= length - n3 + 3);
        }
        return n2;
    }

    @Override
    protected double getTopSurroundTextScaleX(int length, DrawRuleTypeEnum drawRuleTypeEnum) {
        int n2 = 20;
        double d2 = length < n2 ? 0.7 : (length < 37 ? 0.7 - (double)(length - n2) * 0.02 : (length < 46 ? 0.7 - (double)(length - 22) * 0.02 : 0.23));
        return d2;
    }

    private Font getInnerTopSurroundTextFont(int length, Font font) {
        if (length >= 25) {
            return FontUtil.processFont(font, 1, 71 - length);
        }
        return FontUtil.processFont(font, 1, 50);
    }

    private double getInnerTopSurroundTextScaleX(int length) {
        double d2 = 0.46;
        if (length >= 15 && length < 36) {
            d2 = 0.4 - (double)(length - 14) * 0.008;
        } else if (length >= 36) {
            d2 += 0.02;
        }
        return d2;
    }
}

