/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tech.sdk.bean;

import com.timevale.tech.sdk.constants.AlgorithmType;
import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;

public class SignatureConfig {
    private AlgorithmType algorithm = AlgorithmType.HMACSHA256;
    private String esignPublicKey = null;
    private String privateKey = null;

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public String getEsignPublicKey() {
        return this.esignPublicKey;
    }

    public void setEsignPublicKey(String esignPublicKey) {
        this.esignPublicKey = esignPublicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void validate() throws SuperException {
        if (this.getAlgorithm() == AlgorithmType.RSA) {
            AssertSupport.assertNotnull(this.getPrivateKey(), ErrorsDiscriptor.SPEC_EMPTY_INPUT.e("privateKey"));
            AssertSupport.assertNotnull(this.getEsignPublicKey(), ErrorsDiscriptor.SPEC_EMPTY_INPUT.e("esignPublicKey"));
        }
    }
}

