/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tech.sdk.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.timevale.tech.sdk.utils.Base64Util;
import com.timevale.tech.sdk.utils.FontUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeSealUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(QrCodeSealUtils.class);
    private static final int QRCODE_WIDTH = 96;
    private static final int MARGIN_WIDTH = 0;
    private static final int IMAGE_WIDTH = 360;
    private static final int PERSONAL_HEIGHT = 168;
    private static final int ORGANIZE_HEIGHT = 228;
    private static final int QR_MARGIN = 12;
    private static final int ACTUAL_HEIGHT = 340;

    public static String generateQrCodeSeal(String sealData, String viewDetailUrl, String signServiceId, boolean isPersonal) throws WriterException, IOException {
        BufferedImage bufferedImage = QrCodeSealUtils.getImageFromSealData(sealData);
        BufferedImage bufferedImage2 = QrCodeSealUtils.generateQrCodeSeal(bufferedImage, viewDetailUrl, signServiceId, isPersonal);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
        String string = "";
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (null != byArray && byArray.length > 0) {
            string = Base64Util.encode(byArray);
        }
        LOGGER.debug("qrcodeSeal base64 is:{}", (Object)string);
        return string;
    }

    public static BufferedImage generateQrCodeSeal(BufferedImage sealImage, String viewDetailUrl, String signServiceId, boolean isPersonal) throws WriterException {
        int n2 = isPersonal ? 168 : 228;
        sealImage = QrCodeSealUtils.dealImage(sealImage, n2);
        BufferedImage bufferedImage = new BufferedImage(360, 360, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(360, 360, 3);
        graphics2D.dispose();
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        BufferedImage bufferedImage2 = QrCodeSealUtils.generateQrCode(viewDetailUrl);
        graphics2D2.drawImage(bufferedImage2.getScaledInstance(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 4), 12, 254, null);
        graphics2D2.drawImage(sealImage.getScaledInstance(sealImage.getWidth(), sealImage.getHeight(), 4), 120, 18 + (228 - n2) / 2, null);
        graphics2D2.setColor(new Color(0, 0, 0));
        graphics2D2.setFont(FontUtil.getFont("\u96c5\u9ed1", 1, 24.0f));
        graphics2D2.drawString("e\u7b7e\u5b9d\u5b58\u8bc1", 120, 296);
        graphics2D2.setFont(FontUtil.getFont("\u96c5\u9ed1", 1, 20.0f));
        graphics2D2.drawString(signServiceId, 120, 320);
        BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0, 10.0f, null, 0.0f);
        graphics2D2.setStroke(basicStroke);
        graphics2D2.draw(new Line2D.Double(60.0, 132.0, 108.0, 132.0));
        graphics2D2.draw(new Line2D.Double(60.0, 132.0, 60.0, 234.0));
        graphics2D2.dispose();
        return bufferedImage;
    }

    private static BufferedImage getImageFromSealData(String sealData) throws IOException {
        return ImageIO.read(QrCodeSealUtils.base64ToInputStream(sealData));
    }

    private static BufferedImage dealImage(BufferedImage image, int height) {
        int n2 = 0;
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        if (n4 > n3) {
            n2 = height * image.getWidth() / image.getHeight();
        } else {
            n2 = height;
            height = n2 * n4 / n3;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n2, height, 3);
        graphics2D.dispose();
        bufferedImage.createGraphics().drawImage(image.getScaledInstance(n2, height, 4), 0, 0, null);
        return bufferedImage;
    }

    private static BufferedImage generateQrCode(String content) throws WriterException {
        HashMap<EncodeHintType, Object> hashMap = new HashMap<EncodeHintType, Object>();
        hashMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hashMap.put(EncodeHintType.MARGIN, 0);
        hashMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.Q);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 192, 192, hashMap);
        bitMatrix = QrCodeSealUtils.updateBit(bitMatrix, 0);
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        bufferedImage = QrCodeSealUtils.zoomInImage(bufferedImage, 96, 96);
        return bufferedImage;
    }

    private static BitMatrix updateBit(BitMatrix matrix, int margin) {
        int n2 = margin * 2;
        int[] nArray = matrix.getEnclosingRectangle();
        int n3 = nArray[2] + n2;
        int n4 = nArray[3] + n2;
        BitMatrix bitMatrix = new BitMatrix(n3, n4);
        bitMatrix.clear();
        for (int i2 = margin; i2 < n3 - margin; ++i2) {
            for (int i3 = margin; i3 < n4 - margin; ++i3) {
                if (!matrix.get(i2 - margin + nArray[0], i3 - margin + nArray[1])) continue;
                bitMatrix.set(i2, i3);
            }
        }
        return bitMatrix;
    }

    public static BufferedImage zoomInImage(BufferedImage originalImage, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, originalImage.getType());
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(originalImage.getScaledInstance(width, height, 4), 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    private static InputStream base64ToInputStream(String base64) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] byArray = Base64Util.decode(base64);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayInputStream;
    }
}

