/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.engines.RSACoreEngine;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.params.RSABlindingParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

public class RSABlindingEngine
implements AsymmetricBlockCipher {
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private BigInteger blindingFactor;
    private boolean forEncryption;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        RSABlindingParameters rSABlindingParameters;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            rSABlindingParameters = (RSABlindingParameters)parametersWithRandom.getParameters();
        } else {
            rSABlindingParameters = (RSABlindingParameters)cipherParameters;
        }
        this.core.init(bl2, rSABlindingParameters.getPublicKey());
        this.forEncryption = bl2;
        this.key = rSABlindingParameters.getPublicKey();
        this.blindingFactor = rSABlindingParameters.getBlindingFactor();
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) {
        BigInteger bigInteger = this.core.convertInput(byArray, n2, n3);
        bigInteger = this.forEncryption ? this.blindMessage(bigInteger) : this.unblindMessage(bigInteger);
        return this.core.convertOutput(bigInteger);
    }

    private BigInteger blindMessage(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.blindingFactor;
        bigInteger2 = bigInteger.multiply(bigInteger2.modPow(this.key.getExponent(), this.key.getModulus()));
        bigInteger2 = bigInteger2.mod(this.key.getModulus());
        return bigInteger2;
    }

    private BigInteger unblindMessage(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.key.getModulus();
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = this.blindingFactor.modInverse(bigInteger2);
        bigInteger3 = bigInteger3.multiply(bigInteger4);
        bigInteger3 = bigInteger3.mod(bigInteger2);
        return bigInteger3;
    }
}

