/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.prng;

import com.timevale.tgtext.bouncycastle.crypto.prng.EntropySource;
import com.timevale.tgtext.bouncycastle.crypto.prng.EntropySourceProvider;
import com.timevale.tgtext.bouncycastle.crypto.prng.SP800SecureRandom;
import com.timevale.tgtext.bouncycastle.crypto.prng.X931SecureRandom;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl2) {
        this._sr = secureRandom;
        this._predictionResistant = bl2;
    }

    @Override
    public EntropySource get(final int n2) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof SP800SecureRandom || BasicEntropySourceProvider.this._sr instanceof X931SecureRandom) {
                    byte[] byArray = new byte[(n2 + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                    return byArray;
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((n2 + 7) / 8);
            }

            @Override
            public int entropySize() {
                return n2;
            }
        };
    }
}

