/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.DTLSHandshakeRetransmit;
import com.timevale.tgtext.bouncycastle.crypto.tls.DTLSReassembler;
import com.timevale.tgtext.bouncycastle.crypto.tls.DTLSRecordLayer;
import com.timevale.tgtext.bouncycastle.crypto.tls.DeferredHash;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 16;
    private static final int MESSAGE_HEADER_LENGTH = 12;
    private DTLSRecordLayer recordLayer;
    private TlsHandshakeHash handshakeHash;
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext tlsContext, DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
        this.handshakeHash = new DeferredHash();
        this.handshakeHash.init(tlsContext);
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash tlsHandshakeHash = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return tlsHandshakeHash;
    }

    void sendMessage(short s2, byte[] byArray) throws IOException {
        TlsUtils.checkUint24(byArray.length);
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.message_seq++, s2, byArray);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    byte[] receiveMessageBody(short s2) throws IOException {
        Message message = this.receiveMessage();
        if (message.getType() != s2) {
            throw new TlsFatalAlert(10);
        }
        return message.getBody();
    }

    Message receiveMessage() throws IOException {
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight(new Hashtable());
        }
        byte[] byArray = null;
        int n2 = 1000;
        while (true) {
            try {
                while (true) {
                    int n3;
                    Message message;
                    if ((message = this.getPendingMessage()) != null) {
                        return message;
                    }
                    int n4 = this.recordLayer.getReceiveLimit();
                    if (byArray == null || byArray.length < n4) {
                        byArray = new byte[n4];
                    }
                    if ((n3 = this.recordLayer.receive(byArray, 0, n4, n2)) >= 0) {
                        boolean bl2 = this.processRecord(16, this.recordLayer.getReadEpoch(), byArray, 0, n3);
                        if (!bl2) continue;
                        n2 = this.backOff(n2);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.resendOutboundFlight();
            n2 = this.backOff(n2);
        }
    }

    void finish() {
        DTLSHandshakeRetransmit dTLSHandshakeRetransmit = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else {
            this.prepareInboundFlight(null);
            if (this.previousInboundFlight != null) {
                dTLSHandshakeRetransmit = new DTLSHandshakeRetransmit(){

                    @Override
                    public void receivedHandshakeRecord(int n2, byte[] byArray, int n3, int n4) throws IOException {
                        DTLSReliableHandshake.this.processRecord(0, n2, byArray, n3, n4);
                    }
                };
            }
        }
        this.recordLayer.handshakeSuccessful(dTLSHandshakeRetransmit);
    }

    void resetHandshakeMessagesDigest() {
        this.handshakeHash.reset();
    }

    private int backOff(int n2) {
        return Math.min(n2 * 2, 60000);
    }

    private void checkInboundFlight() {
        Enumeration enumeration = this.currentInboundFlight.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 < this.next_receive_seq) continue;
        }
    }

    private Message getPendingMessage() throws IOException {
        byte[] byArray;
        DTLSReassembler dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(this.next_receive_seq));
        if (dTLSReassembler != null && (byArray = dTLSReassembler.getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, dTLSReassembler.getMsgType(), byArray));
        }
        return null;
    }

    private void prepareInboundFlight(Hashtable hashtable) {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = hashtable;
    }

    private boolean processRecord(int n2, int n3, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        int n7;
        boolean bl2 = false;
        while (n5 >= 12 && n5 >= (n7 = (n6 = TlsUtils.readUint24(byArray, n4 + 9)) + 12)) {
            int n8;
            int n9 = TlsUtils.readUint24(byArray, n4 + 1);
            int n10 = TlsUtils.readUint24(byArray, n4 + 6);
            if (n10 + n6 > n9) break;
            short s2 = TlsUtils.readUint8(byArray, n4 + 0);
            int n11 = n8 = s2 == 20 ? 1 : 0;
            if (n3 != n8) break;
            int n12 = TlsUtils.readUint16(byArray, n4 + 4);
            if (n12 < this.next_receive_seq + n2) {
                DTLSReassembler dTLSReassembler;
                if (n12 >= this.next_receive_seq) {
                    dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(n12));
                    if (dTLSReassembler == null) {
                        dTLSReassembler = new DTLSReassembler(s2, n9);
                        this.currentInboundFlight.put(Integers.valueOf(n12), dTLSReassembler);
                    }
                    dTLSReassembler.contributeFragment(s2, n9, byArray, n4 + 12, n10, n6);
                } else if (this.previousInboundFlight != null && (dTLSReassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf(n12))) != null) {
                    dTLSReassembler.contributeFragment(s2, n9, byArray, n4 + 12, n10, n6);
                    bl2 = true;
                }
            }
            n4 += n7;
            n5 -= n7;
        }
        int n13 = n6 = bl2 && DTLSReliableHandshake.checkAll(this.previousInboundFlight) ? 1 : 0;
        if (n6 != 0) {
            this.resendOutboundFlight();
            DTLSReliableHandshake.resetAll(this.previousInboundFlight);
        }
        return n6 != 0;
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i2 = 0; i2 < this.outboundFlight.size(); ++i2) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i2));
        }
    }

    private Message updateHandshakeMessagesDigest(Message message) throws IOException {
        if (message.getType() != 0) {
            byte[] byArray = message.getBody();
            byte[] byArray2 = new byte[12];
            TlsUtils.writeUint8(message.getType(), byArray2, 0);
            TlsUtils.writeUint24(byArray.length, byArray2, 1);
            TlsUtils.writeUint16(message.getSeq(), byArray2, 4);
            TlsUtils.writeUint24(0, byArray2, 6);
            TlsUtils.writeUint24(byArray.length, byArray2, 9);
            this.handshakeHash.update(byArray2, 0, byArray2.length);
            this.handshakeHash.update(byArray, 0, byArray.length);
        }
        return message;
    }

    private void writeMessage(Message message) throws IOException {
        int n2;
        int n3 = this.recordLayer.getSendLimit();
        int n4 = n3 - 12;
        if (n4 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n5 = message.getBody().length;
        int n6 = 0;
        do {
            n2 = Math.min(n5 - n6, n4);
            this.writeHandshakeFragment(message, n6, n2);
        } while ((n6 += n2) < n5);
    }

    private void writeHandshakeFragment(Message message, int n2, int n3) throws IOException {
        RecordLayerBuffer recordLayerBuffer = new RecordLayerBuffer(12 + n3);
        TlsUtils.writeUint8(message.getType(), (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint24(message.getBody().length, recordLayerBuffer);
        TlsUtils.writeUint16(message.getSeq(), recordLayerBuffer);
        TlsUtils.writeUint24(n2, recordLayerBuffer);
        TlsUtils.writeUint24(n3, recordLayerBuffer);
        recordLayerBuffer.write(message.getBody(), n2, n3);
        recordLayerBuffer.sendToRecordLayer(this.recordLayer);
    }

    private static boolean checkAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((DTLSReassembler)enumeration.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DTLSReassembler)enumeration.nextElement()).reset();
        }
    }

    static class Message {
        private final int message_seq;
        private final short msg_type;
        private final byte[] body;

        private Message(int n2, short s2, byte[] byArray) {
            this.message_seq = n2;
            this.msg_type = s2;
            this.body = byArray;
        }

        public int getSeq() {
            return this.message_seq;
        }

        public short getType() {
            return this.msg_type;
        }

        public byte[] getBody() {
            return this.body;
        }
    }

    static class RecordLayerBuffer
    extends ByteArrayOutputStream {
        RecordLayerBuffer(int n2) {
            super(n2);
        }

        void sendToRecordLayer(DTLSRecordLayer dTLSRecordLayer) throws IOException {
            dTLSRecordLayer.send(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

