/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abu;
    protected Alignment abv = Alignment.LEFT;
    protected DrawInterface abw;
    protected char abx = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abu = position;
        this.abw = leader;
        this.abv = alignment;
        this.abx = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.DU(), tabStop.DW(), tabStop.DV(), tabStop.DX());
    }

    public float DU() {
        return this.abu;
    }

    public void an(float f2) {
        this.abu = f2;
    }

    public Alignment DV() {
        return this.abv;
    }

    public void a(Alignment alignment) {
        this.abv = alignment;
    }

    public DrawInterface DW() {
        return this.abw;
    }

    public void a(DrawInterface drawInterface) {
        this.abw = drawInterface;
    }

    public char DX() {
        return this.abx;
    }

    public void k(char c2) {
        this.abx = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abu;
        float f6 = f3 - f2;
        switch (this.abv) {
            case RIGHT: {
                if (f2 + f6 < this.abu) {
                    f5 = this.abu - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abu) {
                    f5 = this.abu - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abu) {
                        f5 = this.abu - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abu ? this.abu - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

