/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class MySSLSocketFactory
implements ProtocolSocketFactory {
    private SSLContext sslcontext = null;

    private SSLContext createSSLContext() {
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        return sSLContext;
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public SSLSocket createSocket(SSLSocket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public SSLSocket createSocket(String host, int port) throws IOException, UnknownHostException {
        return (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public SSLSocket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public SSLSocket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n2 = params.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.getSSLContext().getSocketFactory();
        if (n2 == 0) {
            return (SSLSocket)sSLSocketFactory.createSocket(host, port, localAddress, localPort);
        }
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(host, port);
        sSLSocket.setEnabledCipherSuites(new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"});
        sSLSocket.bind(inetSocketAddress);
        sSLSocket.connect(inetSocketAddress2, n2);
        return sSLSocket;
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

