/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBoolean;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.tsp.TimeStampResp;
import com.timevale.tgtext.bouncycastle.asn1.util.DERDump;
import com.timevale.tgtext.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.timevale.tgtext.bouncycastle.asn1.x500.RDN;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.tgtext.bouncycastle.tsp.TSPAlgorithms;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequest;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequestGenerator;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampResponse;
import com.timevale.tgtext.bouncycastle.util.Store;
import esign.utils.Base64;
import esign.utils.security.CertInfo;
import esign.utils.security.provider.Provider;
import esign.utils.security.provider.SecurityProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerValue;

public class CommonCertUtil {
    private static String X500_ID_AT_COMMON_NAME = "2.5.4.3";
    private static final int MASKBITS = 63;
    private static final int MASKBYTE = 128;
    private static final int MASK2BYTES = 192;
    private static final int MASK3BYTES = 224;

    public static CertInfo getCertInfo(byte[] certBytes) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
            X509Certificate x509Certificate = null;
            while (((InputStream)byteArrayInputStream).available() > 0) {
                x509Certificate = (X509Certificate)SecurityProvider.Default.factory().generateCertificate(byteArrayInputStream);
            }
            return new CertInfo(x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] UNICODE_TO_UTF8(byte[] b2) {
        int n2 = 0;
        byte[] byArray = new byte[b2.length * 2];
        for (int i2 = 0; i2 < b2.length; i2 += 2) {
            byte[] byArray2 = new byte[1];
            int n3 = b2[i2] & 0xFF | (b2[i2 + 1] & 0xFF) << 8;
            if (n3 < 128) {
                byArray2 = new byte[]{(byte)n3};
            } else if (n3 < 2048) {
                byArray2 = new byte[]{(byte)(0xC0 | n3 >> 6), (byte)(0x80 | n3 & 0x3F)};
            } else if (n3 < 65536) {
                byArray2 = new byte[]{(byte)(0xE0 | n3 >> 12), (byte)(0x80 | n3 >> 6 & 0x3F), (byte)(0x80 | n3 & 0x3F)};
            }
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                byArray[n2++] = byArray2[i3];
            }
        }
        b2 = new byte[n2];
        System.arraycopy(byArray, 0, b2, 0, n2);
        return b2;
    }

    public static byte[] CreateTimeStampRequest(byte[] inData) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(inData);
            byte[] byArray = messageDigest.digest();
            TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
            timeStampRequestGenerator.setCertReq(true);
            TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, byArray);
            byte[] byArray2 = timeStampRequest.getEncoded();
            return byArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getIsuserFromSignedData(String signedData) {
        String string = null;
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            CMSSignedData cMSSignedData = new CMSSignedData(bASE64Decoder.decodeBuffer(signedData));
            Store<X509CertificateHolder> store = cMSSignedData.getCertificates();
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection<SignerInformation> collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                RDN[] rDNArray;
                Collection<X509CertificateHolder> collection2 = store.getMatches(signerInformation.getSID());
                Iterator<X509CertificateHolder> iterator = collection2.iterator();
                X509CertificateHolder x509CertificateHolder = iterator.next();
                X500Name x500Name = x509CertificateHolder.getIssuer();
                block3: for (RDN rDN : rDNArray = x500Name.getRDNs()) {
                    for (AttributeTypeAndValue attributeTypeAndValue : rDN.getTypesAndValues()) {
                        if (!X500_ID_AT_COMMON_NAME.equals(attributeTypeAndValue.getType().toString())) continue;
                        string = attributeTypeAndValue.getValue().toString();
                        continue block3;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25");
        }
        return string;
    }

    public static boolean VerifyPkcs7Signature(String signedData) {
        boolean bl2 = false;
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            CMSSignedData cMSSignedData = new CMSSignedData(bASE64Decoder.decodeBuffer(signedData));
            Store<X509CertificateHolder> store = cMSSignedData.getCertificates();
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection<SignerInformation> collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                Collection<X509CertificateHolder> collection2 = store.getMatches(signerInformation.getSID());
                Iterator<X509CertificateHolder> iterator = collection2.iterator();
                X509CertificateHolder x509CertificateHolder = iterator.next();
                if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509CertificateHolder))) {
                    bl2 = true;
                    System.out.println("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u6210\u529f");
                    continue;
                }
                bl2 = false;
            }
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
            System.out.println("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25");
        }
        return bl2;
    }

    public static byte[] CreateTimeStampResponse(String tspurl, byte[] request) {
        try {
            URL uRL = new URL(tspurl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/timestamp-query");
            httpURLConnection.setRequestProperty("Accept", "application/timestamp-reply");
            httpURLConnection.setRequestProperty("Content-length", String.valueOf(request.length));
            OutputStream outputStream = null;
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(request);
            outputStream.flush();
            InputStream inputStream = httpURLConnection.getInputStream();
            TimeStampResp timeStampResp = TimeStampResp.getInstance(new ASN1InputStream(inputStream).readObject());
            TimeStampResponse timeStampResponse = new TimeStampResponse(timeStampResp);
            return timeStampResponse.getEncoded();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean VerifyTimeStamp(byte[] indata, byte[] tsResponseData) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(indata);
            byte[] byArray = messageDigest.digest();
            TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
            TimeStampRequest timeStampRequest = timeStampRequestGenerator.generate(TSPAlgorithms.SHA1, byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tsResponseData);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            TimeStampResp timeStampResp = TimeStampResp.getInstance(aSN1InputStream.readObject());
            TimeStampResponse timeStampResponse = new TimeStampResponse(timeStampResp);
            timeStampResponse.validate(timeStampRequest);
            aSN1InputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean validateCertByTime(byte[] certBytes) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = null;
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String string = simpleDateFormat.format(new Date()) + "GMT+00:00";
            return string.compareTo(x509CertificateStructure.getStartDate().getTime().toString()) > 0 && string.compareTo(x509CertificateStructure.getEndDate().getTime().toString()) < 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean checkCertValid(byte[] certBytes) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = null;
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
            String string = simpleDateFormat.format(new Date()) + "GMT+00:00";
            return string.compareTo(x509CertificateStructure.getStartDate().getTime().toString()) > 0 && string.compareTo(x509CertificateStructure.getEndDate().getTime().toString()) < 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean validateCertCrl(SecurityProvider provider, byte[] certBytes) {
        try {
            boolean bl2 = true;
            String string = this.getClass().getClassLoader().getResource("").getFile();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = null;
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            String string2 = x509CertificateStructure.getSerialNumber().getValue().toString(16).toUpperCase();
            FileInputStream fileInputStream = new FileInputStream(string + "ca.crl");
            X509CRL x509CRL = (X509CRL)provider.factory().generateCRL(fileInputStream);
            boolean bl3 = false;
            Set<? extends X509CRLEntry> set = x509CRL.getRevokedCertificates();
            for (X509CRLEntry x509CRLEntry : set) {
                String string3 = x509CRLEntry.getSerialNumber().toString(16).toUpperCase();
                String string4 = x509CRL.getIssuerDN().toString();
                if (!string3.equals(string2)) continue;
                bl2 = false;
                break;
            }
            return bl2;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean validateCertByRedlist(byte[] certBytes, String file) {
        boolean bl2 = false;
        try {
            File file2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = null;
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            String string = x509CertificateStructure.getSerialNumber().getValue().toString(16);
            if (string == null || string.length() < 1) {
                return false;
            }
            if ((string = string.toUpperCase()).startsWith("00")) {
                string = string.substring(2);
            }
            if (string.startsWith("0")) {
                string = string.substring(1);
            }
            if (!(file2 = new File(file)).exists()) {
                return true;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
            String string2 = randomAccessFile.readLine();
            while (string2 != null) {
                if (string2.startsWith(string)) {
                    bl2 = true;
                    break;
                }
                string2 = randomAccessFile.readLine();
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl2;
        }
        return bl2;
    }

    public static String getExtensionByCert(SecurityProvider provider, String oid, byte[] certBytes) {
        String string = "";
        try {
            if (!provider.equals((Object)SecurityProvider.Default)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
                X509Extension x509Extension = null;
                while (((InputStream)byteArrayInputStream).available() > 0) {
                    x509Extension = (X509Certificate)provider.factory().generateCertificate(byteArrayInputStream);
                }
                if (x509Extension != null) {
                    string = x509Extension.getExtensionValue(oid) != null ? new String(x509Extension.getExtensionValue(oid), "UTF-8") : "";
                }
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1Sequence aSN1Sequence = null;
                aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
                X509Extensions x509Extensions = x509CertificateStructure.getTBSCertificate().getExtensions();
                DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(oid);
                com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension x509Extension = null;
                if (x509Extensions != null) {
                    x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                    boolean bl2 = x509Extension.isCritical();
                    ASN1OctetString aSN1OctetString = x509Extension.getValue();
                    string = new String(aSN1OctetString.getOctets());
                }
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String unicodeToUtf8(String theString) {
        int n2 = theString.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if ((n4 = theString.charAt(n3++)) == 92) {
                if ((n4 = theString.charAt(n3++)) == 117) {
                    int n5 = 0;
                    block6: for (int i2 = 0; i2 < 4; ++i2) {
                        n4 = theString.charAt(n3++);
                        switch (n4) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n5 = (n5 << 4) + n4 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n5 = (n5 << 4) + 10 + n4 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n5 = (n5 << 4) + 10 + n4 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n5);
                    continue;
                }
                if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 102) {
                    n4 = 12;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    private static void getKeyUsage(X509Extensions ext) {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("2.5.29.15");
        com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension x509Extension = null;
        try {
            x509Extension = ext.getExtension(dERObjectIdentifier);
            boolean bl2 = x509Extension.isCritical();
            ASN1OctetString aSN1OctetString = x509Extension.getValue();
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void getBasicConstrains(X509Extensions ext) {
        byte[] byArray = CommonCertUtil.getExtensionBytes("2.5.29.19", ext);
        if (byArray != null) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                if (aSN1Sequence.size() == 2) {
                    if (((DERBoolean)aSN1Sequence.getObjectAt(0)).isTrue()) {
                        int n2 = ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue().intValue();
                        System.out.println("\u662fCA\u8bc1\u4e66/tmax path len=" + n2);
                    } else {
                        System.out.println("\u4e0d\u662fca\u8bc1\u4e66!");
                    }
                } else if (aSN1Sequence.size() == 1) {
                    System.out.println("\u4e0d\u662fca\u8bc1\u4e66!" + aSN1Sequence.getObjectAt(1).toString());
                    if (aSN1Sequence.getObjectAt(0) instanceof DERBoolean && ((DERBoolean)aSN1Sequence.getObjectAt(0)).isTrue()) {
                        System.out.println(Integer.MAX_VALUE);
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("error processing key usage extension");
            }
        }
    }

    private static String getCrlDistributionPoints(X509Extensions ext) throws IOException {
        String string = "";
        byte[] byArray = CommonCertUtil.getExtensionBytes(X509Extensions.CRLDistributionPoints.getId(), ext);
        if (byArray == null) {
            return string;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        byte[] byArray2 = aSN1InputStream.readObject().getEncoded();
        ASN1InputStream aSN1InputStream2 = new ASN1InputStream(new ByteArrayInputStream(byArray2));
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance(aSN1InputStream2.readObject());
        for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName == null || distributionPointName.getType() != 0) continue;
            GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
            for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
                if (generalNameArray[i2].getTagNo() != 6) continue;
                String string2 = DERIA5String.getInstance(generalNameArray[i2].getName()).getString();
                string = string + string2;
            }
        }
        return string;
    }

    public static void getCertPolicy(X509Extensions ext) {
        byte[] byArray = CommonCertUtil.getExtensionBytes("2.5.29.32", ext);
        if (byArray != null) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                String string = DERDump.dumpAsString(aSN1Sequence);
                for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                    CommonCertUtil.getPolicyInfo((ASN1Sequence)aSN1Sequence.getObjectAt(i2));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void getPolicyInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)seq.getObjectAt(0);
            System.out.println("\u8bc1\u4e66\u7b56\u7565\u6807\u8bc6:" + dERObjectIdentifier.getId());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)seq.getObjectAt(1);
            for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                CommonCertUtil.getPolicyQualifierInfo((ASN1Sequence)aSN1Sequence.getObjectAt(i2));
            }
        } else {
            System.out.println("\u89e3\u6790\u7b56\u7565\u58f0\u660e\u65f6\u51fa\u9519!");
        }
    }

    private static void getPolicyQualifierInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)seq.getObjectAt(0);
            System.out.println("\u7b56\u7565\u58f0\u660e\u6807\u8bc6:" + dERObjectIdentifier.getId());
            DERIA5String dERIA5String = (DERIA5String)seq.getObjectAt(1);
            System.out.println("\u58f0\u660e\u5185\u5bb9:" + dERIA5String.getString());
        }
    }

    private static byte[] getExtensionBytes(String oid, X509Extensions exts) {
        com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension x509Extension;
        if (exts != null && (x509Extension = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            return x509Extension.getValue().getOctets();
        }
        return null;
    }

    public static Certificate getCertFromBytes(byte[] bts) {
        Certificate certificate = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bts);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            return certificate;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Certificate getCertFromFile(String fp2) {
        Certificate certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(fp2);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (fileInputStream.available() > 0) {
                certificate = certificateFactory.generateCertificate(fileInputStream);
            }
            return certificate;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return certificate;
        }
    }

    public static String getInfoFromDn(String dn2, String key) {
        String[] stringArray = dn2.split(",");
        if (0 == stringArray.length) {
            return "";
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].trim();
            if (!stringArray[i2].toUpperCase().contains(key.toUpperCase())) continue;
            return stringArray[i2].substring(stringArray[i2].indexOf(key.toUpperCase()) + key.length(), stringArray[i2].length());
        }
        return "";
    }

    public static byte[] fileToByteArray(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n2 = 1024;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (-1 != (n3 = bufferedInputStream.read(byArray, 0, n2))) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byteArrayOutputStream.close();
        }
    }

    public static boolean pkcs1verify(PublicKey pubKey, byte[] plainText, byte[] signText) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(pubKey);
            signature.update(plainText);
            signature.update((byte)48);
            return signature.verify(signText);
        }
        catch (Throwable throwable) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            throwable.printStackTrace();
            return false;
        }
    }

    public byte[] ConstructP7Data(SecurityProvider provider, byte[] inData, byte[] signedAttributes, byte[] certbytes) {
        Object var5_5 = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certbytes);
            X509Certificate x509Certificate = null;
            while (((InputStream)byteArrayInputStream).available() > 0) {
                x509Certificate = (X509Certificate)provider.factory().generateCertificate(byteArrayInputStream);
            }
            ContentInfo contentInfo = null;
            Field field = ContentInfo.class.getField("DATA_OID");
            DerValue derValue = new DerValue(Base64.encode(inData).trim());
            contentInfo = new ContentInfo(ContentInfo.DIGESTED_DATA_OID, derValue);
            BigInteger bigInteger = x509Certificate.getSerialNumber();
            Class<?> clazz = Class.forName("sun.security.x509.X500Name");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object obj = constructor.newInstance(x509Certificate.getIssuerDN().getName());
            String string = "SHA1";
            String string2 = "SHA1withRSA";
            X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
            Class<?> clazz2 = Class.forName("sun.security.x509.AlgorithmId");
            Method method = clazz2.getMethod("get", String.class);
            Object object = method.invoke(null, string);
            Field field2 = clazz2.getField("RSAEncryption_oid");
            Object object2 = field2.get(null);
            Class<?> clazz3 = Class.forName("sun.security.util.ObjectIdentifier");
            Constructor<?> constructor2 = clazz2.getConstructor(clazz3);
            Object obj2 = constructor2.newInstance(object2);
            Constructor constructor3 = SignerInfo.class.getConstructor(clazz, BigInteger.class, clazz2, PKCS9Attributes.class, clazz2, byte[].class, PKCS9Attributes.class);
            SignerInfo signerInfo = (SignerInfo)constructor3.newInstance(obj, bigInteger, object, null, obj2, signedAttributes, null);
            SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
            Object object3 = Array.newInstance(clazz2, 1);
            Array.set(object3, 0, object);
            Constructor constructor4 = PKCS7.class.getConstructor(object3.getClass(), ContentInfo.class, X509Certificate[].class, signerInfoArray.getClass());
            PKCS7 pKCS7 = (PKCS7)constructor4.newInstance(object3, contentInfo, x509CertificateArray, signerInfoArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            pKCS7.encodeSignedData(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] GetP7SignDataInfo(byte[] signeddata, String type) {
        Object var3_3 = null;
        try {
            PKCS7 pKCS7 = new PKCS7(signeddata);
            if (type.equals("1")) {
                return Base64.decode(pKCS7.getContentInfo().getContent().getAsString());
            }
            if (type.equals("2")) {
                return pKCS7.getSignerInfos()[0].getEncryptedDigest();
            }
            if (type.equals("3")) {
                return pKCS7.getCertificates()[0].getEncoded();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] HashDigest(byte[] indata) {
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("sha-1");
            messageDigest.update(indata);
            byArray = messageDigest.digest();
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean pkcs1verify(String cert, String plaintext, String signText, String signalg) {
        try {
            Signature signature = Signature.getInstance(signalg);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(cert));
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (cert != null) {
                signature.initVerify(certificate.getPublicKey());
                signature.update(Base64.decode(plaintext));
                return signature.verify(Base64.decode(signText));
            }
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            throwable.printStackTrace();
            return false;
        }
    }

    static {
        Provider.BC.install();
    }
}

