/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security;

import esign.utils.Base64;
import esign.utils.coding.Coder;
import esign.utils.exception.SuperException;
import esign.utils.security.provider.DigestProivder;
import java.security.MessageDigest;

public enum MessageDigestUtil {
    INSTANCE;


    public byte[] digest(byte[] origin, DigestProivder proivder) {
        MessageDigest messageDigest = proivder.provider();
        messageDigest.update(origin, 0, origin.length);
        return messageDigest.digest();
    }

    public String digestB64(byte[] origin, DigestProivder proivder) {
        byte[] byArray = this.digest(origin, proivder);
        return Base64.encode(byArray);
    }

    public String digest(byte[] origin, DigestProivder proivder, Coder coder) throws SuperException {
        byte[] byArray = this.digest(origin, proivder);
        return coder.encode(byArray);
    }
}

