/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.verify;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import java.util.ArrayList;
import java.util.List;

public class VerifyResult {
    private List<SignerInfo> result = new ArrayList<SignerInfo>();
    private boolean verifies = false;

    public void add(X509CertificateHolder cert, boolean verify) {
        this.result.add(new SignerInfo(cert, verify));
        if (this.verifies && !verify) {
            this.verifies = false;
        }
    }

    public List<SignerInfo> getResult() {
        return this.result;
    }

    public void setResult(List<SignerInfo> result) {
        this.result = result;
    }

    public boolean isVerifies() {
        if (!this.verifies) {
            return false;
        }
        for (SignerInfo signerInfo : this.result) {
            if (signerInfo.isVerify()) continue;
            return false;
        }
        return true;
    }

    public void setVerifies(boolean verifies) {
        this.verifies = verifies;
    }

    public static class SignerInfo {
        private X509CertificateHolder cert;
        private boolean verify;

        public SignerInfo(X509CertificateHolder cert, boolean verify) {
            this.cert = cert;
            this.verify = verify;
        }

        public X509CertificateHolder getCert() {
            return this.cert;
        }

        public void setCert(X509CertificateHolder cert) {
            this.cert = cert;
        }

        public boolean isVerify() {
            return this.verify;
        }

        public void setVerify(boolean verify) {
            this.verify = verify;
        }
    }
}

