/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.timeunit;

import esign.utils.timeunit.ITimeUnit;

public enum TimeUnit implements ITimeUnit
{
    MILLISECOND(1L),
    SECOND(MILLISECOND, 1000),
    MINUTE(SECOND, 60),
    HOUR(MINUTE, 60),
    DAY(HOUR, 24),
    INFINITE(-1L);

    private long tick;

    private TimeUnit(long tick) {
        this.tick = tick;
    }

    private TimeUnit(TimeUnit parent, int parentCount) {
        this.tick = parent.milliTick() * (long)parentCount;
    }

    @Override
    public long milliTick() {
        return this.tick;
    }

    public ITimeUnit unit(final int count) {
        return new ITimeUnit(){

            @Override
            public long milliTick() {
                return (long)count * TimeUnit.this.tick;
            }
        };
    }
}

