/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.common;

import com.timevale.esign.paas.tech.bean.bean.AccountBean;
import com.timevale.esign.paas.tech.bean.model.AccountAddModel;
import com.timevale.esign.paas.tech.bean.model.AccountUpdateModel;
import com.timevale.esign.paas.tech.bean.request.OnlineCreateLegalRepAuthParam;
import com.timevale.esign.paas.tech.bean.request.OrganizeParam;
import com.timevale.esign.paas.tech.bean.request.PersonParam;
import com.timevale.esign.paas.tech.bean.request.UpdateOrganizeParam;
import com.timevale.esign.paas.tech.bean.request.UpdatePersonParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convertor {
    private static final Logger log = LoggerFactory.getLogger(Convertor.class);

    public static AccountAddModel.Account convert(PersonParam person) {
        AccountAddModel.Account account = Convertor.convertAccount(person);
        AccountAddModel.Person person2 = new AccountAddModel.Person();
        person2.setIdNo(person.getIdNo());
        person2.setName(person.getName());
        person2.setPersonArea(person.getIdNoType().type());
        account.setPerson(person2);
        return account;
    }

    public static AccountAddModel.Account convert(OrganizeParam organize) {
        AccountAddModel.Account account = Convertor.convertAccount(organize);
        AccountAddModel.Organize organize2 = new AccountAddModel.Organize();
        organize2.setName(organize.getName());
        organize2.setOrganCode(organize.getOrgCode());
        organize2.setLicenseType(organize.getRegType().val());
        account.setOrgan(organize2);
        return account;
    }

    public static AccountUpdateModel.Account convert(UpdatePersonParam updatePerson) {
        AccountUpdateModel.Account account = Convertor.convertUpdateAccount(updatePerson);
        account.setAccountUid(updatePerson.getAccountId());
        AccountUpdateModel.Person person = new AccountUpdateModel.Person();
        person.setName(updatePerson.getName());
        account.setPerson(person);
        return account;
    }

    public static AccountUpdateModel.Account convert(UpdateOrganizeParam updateOrganize) {
        AccountUpdateModel.Account account = Convertor.convertUpdateAccount(updateOrganize);
        account.setAccountUid(updateOrganize.getAccountId());
        AccountUpdateModel.Organize organize = new AccountUpdateModel.Organize();
        organize.setName(updateOrganize.getName());
        account.setOrgan(organize);
        return account;
    }

    private static AccountAddModel.Account convertAccount(AccountBean input) {
        AccountAddModel.Account account = new AccountAddModel.Account();
        return account;
    }

    private static AccountUpdateModel.Account convertUpdateAccount(AccountBean input) {
        AccountUpdateModel.Account account = new AccountUpdateModel.Account();
        return account;
    }

    public static AccountAddModel.Account convert(OnlineCreateLegalRepAuthParam param) {
        AccountAddModel.Account account = new AccountAddModel.Account();
        AccountAddModel.Person person = new AccountAddModel.Person();
        person.setIdNo(param.getIdNo());
        person.setName(param.getName());
        person.setPersonArea(param.getIdNoType().type());
        account.setPerson(person);
        return account;
    }
}

