/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.guava.common.collect.Maps;
import com.timevale.seal.sdk.util.StringUtils;
import java.util.Map;

public enum SealSpecEnum {
    IMAGE("\u5370\u7ae0Base64"),
    GB_SEAL("\u56fd\u6807\u5370\u7ae0");

    private String desc;
    static Map<String, SealSpecEnum> items;

    private SealSpecEnum(String desc) {
        this.desc = desc;
    }

    public String desc() {
        return this.desc;
    }

    public static SealSpecEnum of(String sealSpec) {
        if (StringUtils.isBlank(sealSpec)) {
            return IMAGE;
        }
        return items.getOrDefault(sealSpec.toUpperCase(), IMAGE);
    }

    public static boolean valid(String sealSpec) {
        if (StringUtils.isBlank(sealSpec)) {
            return false;
        }
        return items.containsKey(sealSpec.toUpperCase());
    }

    static {
        items = Maps.newHashMap();
        for (SealSpecEnum sealSpecEnum : SealSpecEnum.values()) {
            items.put(sealSpecEnum.name(), sealSpecEnum);
        }
    }
}

