/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.annotations.GwtIncompatible;
import com.timevale.guava.common.base.Objects;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.BiMap;
import com.timevale.guava.common.collect.ForwardingMap;
import com.timevale.guava.common.collect.ForwardingMapEntry;
import com.timevale.guava.common.collect.ForwardingSet;
import com.timevale.guava.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Map<K, V> delegate;
    private transient AbstractBiMap<V, K> inverse;
    private transient Set<K> keySet;
    private transient Set<V> valueSet;
    private transient Set<Map.Entry<K, V>> entrySet;
    @GwtIncompatible(value="Not needed in emulated source.")
    private static final long serialVersionUID = 0L;

    AbstractBiMap(Map<K, V> forward, Map<V, K> backward) {
        this.setDelegates(forward, backward);
    }

    private AbstractBiMap(Map<K, V> backward, AbstractBiMap<V, K> forward) {
        this.delegate = backward;
        this.inverse = forward;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        Preconditions.checkState(this.delegate == null);
        Preconditions.checkState(this.inverse == null);
        Preconditions.checkArgument(forward.isEmpty());
        Preconditions.checkArgument(backward.isEmpty());
        Preconditions.checkArgument(forward != backward);
        this.delegate = forward;
        this.inverse = new Inverse<V, K>(backward, this);
    }

    void setInverse(AbstractBiMap<V, K> inverse) {
        this.inverse = inverse;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public V put(K key, V value) {
        return this.putInBothMaps(key, value, false);
    }

    @Override
    public V forcePut(K key, V value) {
        return this.putInBothMaps(key, value, true);
    }

    private V putInBothMaps(@Nullable K key, @Nullable V value, boolean force) {
        boolean bl2 = this.containsKey(key);
        if (bl2 && Objects.equal(value, this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else {
            Preconditions.checkArgument(!this.containsValue(value), "value already present: %s", value);
        }
        V v2 = this.delegate.put(key, value);
        this.updateInverseMap(key, bl2, v2, value);
        return v2;
    }

    private void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(oldValue);
        }
        this.inverse.delegate.put(newValue, key);
    }

    @Override
    public V remove(Object key) {
        return this.containsKey(key) ? (V)this.removeFromBothMaps(key) : null;
    }

    private V removeFromBothMaps(Object key) {
        V v2 = this.delegate.remove(key);
        this.removeFromInverseMap(v2);
        return v2;
    }

    private void removeFromInverseMap(V oldValue) {
        this.inverse.delegate.remove(oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet == null ? (this.keySet = new KeySet()) : keySet;
    }

    @Override
    public Set<V> values() {
        ValueSet valueSet = this.valueSet;
        return valueSet == null ? (this.valueSet = new ValueSet()) : valueSet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    private static class Inverse<K, V>
    extends AbstractBiMap<K, V> {
        @GwtIncompatible(value="Not needed in emulated source.")
        private static final long serialVersionUID = 0L;

        private Inverse(Map<K, V> backward, AbstractBiMap<V, K> forward) {
            super(backward, forward);
        }

        @GwtIncompatible(value="java.io.ObjectOuputStream")
        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(this.inverse());
        }

        @GwtIncompatible(value="java.io.ObjectInputStream")
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.setInverse((AbstractBiMap)stream.readObject());
        }

        @GwtIncompatible(value="Not needed in the emulated source.")
        Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.this.delegate.entrySet();
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (!this.esDelegate.contains(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            AbstractBiMap.this.inverse.delegate.remove(entry.getValue());
            this.esDelegate.remove(entry);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator iterator = this.esDelegate.iterator();
            return new Iterator<Map.Entry<K, V>>(){
                Map.Entry<K, V> entry;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.entry = (Map.Entry)iterator.next();
                    final Map.Entry entry = this.entry;
                    return new ForwardingMapEntry<K, V>(){

                        @Override
                        protected Map.Entry<K, V> delegate() {
                            return entry;
                        }

                        @Override
                        public V setValue(V value) {
                            Preconditions.checkState(EntrySet.this.contains(this), "entry no longer in map");
                            if (Objects.equal(value, this.getValue())) {
                                return value;
                            }
                            Preconditions.checkArgument(!AbstractBiMap.this.containsValue(value), "value already present: %s", value);
                            Object v2 = entry.setValue(value);
                            Preconditions.checkState(Objects.equal(value, AbstractBiMap.this.get(this.getKey())), "entry no longer in map");
                            AbstractBiMap.this.updateInverseMap(this.getKey(), true, v2, value);
                            return v2;
                        }
                    };
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.entry != null);
                    Object v2 = this.entry.getValue();
                    iterator.remove();
                    AbstractBiMap.this.removeFromInverseMap(v2);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        @Override
        public boolean contains(Object o2) {
            return Maps.containsEntryImpl(this.delegate(), o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.standardContainsAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.standardRemoveAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.standardRetainAll(c2);
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = AbstractBiMap.this.inverse.keySet();
        }

        @Override
        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iterator = AbstractBiMap.this.delegate.values().iterator();
            return new Iterator<V>(){
                V valueToRemove;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    this.valueToRemove = iterator.next();
                    return this.valueToRemove;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    AbstractBiMap.this.removeFromInverseMap(this.valueToRemove);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    private class KeySet
    extends ForwardingSet<K> {
        private KeySet() {
        }

        @Override
        protected Set<K> delegate() {
            return AbstractBiMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(Object key) {
            if (!this.contains(key)) {
                return false;
            }
            AbstractBiMap.this.removeFromBothMaps(key);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> keysToRemove) {
            return this.standardRemoveAll(keysToRemove);
        }

        @Override
        public boolean retainAll(Collection<?> keysToRetain) {
            return this.standardRetainAll(keysToRetain);
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator iterator = AbstractBiMap.this.delegate.entrySet().iterator();
            return new Iterator<K>(){
                Map.Entry<K, V> entry;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = (Map.Entry)iterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.entry != null);
                    Object v2 = this.entry.getValue();
                    iterator.remove();
                    AbstractBiMap.this.removeFromInverseMap(v2);
                }
            };
        }
    }
}

