/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.primitives;

import com.timevale.guava.common.annotations.VisibleForTesting;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.primitives.UnsignedLongs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import sun.misc.Unsafe;

public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > 255L) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a2, byte b2) {
        return UnsignedBytes.toInt(a2) - UnsignedBytes.toInt(b2);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int n2 = UnsignedBytes.toInt(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            int n3 = UnsignedBytes.toInt(array[i2]);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return (byte)n2;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int n2 = UnsignedBytes.toInt(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            int n3 = UnsignedBytes.toInt(array[i2]);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return (byte)n2;
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 5);
        stringBuilder.append(UnsignedBytes.toInt(array[0]));
        for (int i2 = 1; i2 < array.length; ++i2) {
            stringBuilder.append(separator).append(UnsignedBytes.toInt(array[i2]));
        }
        return stringBuilder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> clazz = Class.forName(UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)clazz.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable throwable) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int n2 = Math.min(left.length, right.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = UnsignedBytes.compare(left[i2], right[i2]);
                    if (n3 == 0) continue;
                    return n3;
                }
                return left.length - right.length;
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean littleEndian;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            @Override
            public int compare(byte[] left, byte[] right) {
                int n2;
                int n3 = Math.min(left.length, right.length);
                int n4 = n3 / 8;
                for (n2 = 0; n2 < n4 * 8; n2 += 8) {
                    int n5;
                    long l2;
                    long l3 = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)n2);
                    long l4 = l3 ^ (l2 = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)n2));
                    if (l4 == 0L) continue;
                    if (!littleEndian) {
                        return UnsignedLongs.compare(l3, l2);
                    }
                    int n6 = 0;
                    int n7 = (int)l4;
                    if (n7 == 0) {
                        n7 = (int)(l4 >>> 32);
                        n6 = 32;
                    }
                    if ((n5 = n7 << 16) == 0) {
                        n6 += 16;
                    } else {
                        n7 = n5;
                    }
                    n5 = n7 << 8;
                    if (n5 == 0) {
                        n6 += 8;
                    }
                    return (int)((l3 >>> n6 & 0xFFL) - (l2 >>> n6 & 0xFFL));
                }
                for (n2 = n4 * 8; n2 < n3; ++n2) {
                    int n8 = UnsignedBytes.compare(left[n2], right[n2]);
                    if (n8 == 0) continue;
                    return n8;
                }
                return left.length - right.length;
            }

            static {
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
                theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field field = Unsafe.class.getDeclaredField("theUnsafe");
                            field.setAccessible(true);
                            return field.get(null);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            throw new Error();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new Error();
                        }
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }
    }
}

