/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.util;

import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.util.StringUtils;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtil {
    private static final Logger log = LoggerFactory.getLogger(FontUtil.class);
    private static final String FONT_KEY_FORMAT = "%s_%s_%s";
    private static final Map<String, Font> NEW_FONT_MAP = new HashMap<String, Font>();
    private static final Map<String, Font> ORIGIN_FONT_MAP = new HashMap<String, Font>();
    private static final String FONT_PATH_CONTAIN_SUFFIX_FORMAT = "fonts/%s.ttf";
    private static final String FONT_PATH_FORMAT = "fonts/%s";
    private static final String PATH_1 = "%s/%s.ttf";
    private static final String PATH_2 = "%s%s.ttf";
    private static final String PATH_3 = "%s/%s";

    public static Font loadFont(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            throw new SealSdkException("\u5b57\u4f53\u540d\u79f0\u4e3a\u7a7a");
        }
        String string = fileName.contains(".") ? String.format(FONT_PATH_FORMAT, fileName) : String.format(FONT_PATH_CONTAIN_SUFFIX_FORMAT, fileName);
        InputStream inputStream = null;
        try {
            inputStream = FontUtil.class.getClassLoader().getResourceAsStream(string);
            Font font = FontUtil.loadFont(fileName, string, inputStream);
            return font;
        }
        catch (Exception exception) {
            throw new SealSdkException("\u52a0\u8f7d resources/fonts/ \u76ee\u5f55\u4e0b\u7684\u5b57\u4f53\u5f02\u5e38", exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Font loadFontByRelativePath(String fileName, String relativePath) {
        if (StringUtils.isBlank(fileName)) {
            throw new SealSdkException("\u5b57\u4f53\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(relativePath)) {
            throw new SealSdkException("\u76f8\u5bf9\u8def\u5f84\u4e3a\u7a7a");
        }
        String string = fileName.contains(".") ? String.format(PATH_3, relativePath, fileName) : String.format(PATH_1, relativePath, fileName);
        InputStream inputStream = null;
        try {
            inputStream = FontUtil.class.getClassLoader().getResourceAsStream(string);
            Font font = FontUtil.loadFont(fileName, string, inputStream);
            return font;
        }
        catch (Exception exception) {
            throw new SealSdkException("\u52a0\u8f7d " + relativePath + " \u76ee\u5f55\u4e0b\u7684\u5b57\u4f53\u5f02\u5e38", exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Font loadFontFromPath(String absolutePath, String fileName) {
        if (StringUtils.isBlank(absolutePath)) {
            throw new SealSdkException("\u5b57\u4f53\u8def\u5f84\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(fileName)) {
            throw new SealSdkException("\u5b57\u4f53\u540d\u79f0\u4e3a\u7a7a");
        }
        String string = absolutePath.endsWith("/") ? String.format(PATH_2, absolutePath, fileName) : String.format(PATH_1, absolutePath, fileName);
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(Paths.get(string, new String[0]), new OpenOption[0]);
            Font font = FontUtil.loadFont(fileName, string, inputStream);
            return font;
        }
        catch (Exception exception) {
            throw new SealSdkException("\u52a0\u8f7d " + absolutePath + " \u76ee\u5f55\u4e0b\u7684\u5b57\u4f53\u5f02\u5e38", exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font loadFont(String fileName, String path, InputStream fontStream) throws IOException, FontFormatException {
        Font font = ORIGIN_FONT_MAP.get(path);
        if (font != null) {
            return font;
        }
        Map<String, Font> map = ORIGIN_FONT_MAP;
        synchronized (map) {
            font = ORIGIN_FONT_MAP.get(path);
            if (font != null) {
                return font;
            }
            if (fontStream == null) {
                log.warn("\u6ca1\u6709\u52a0\u8f7d\u7684 [{}] \u5b57\u4f53...", (Object)path);
                font = new Font(fileName, 1, 50);
            } else {
                font = Font.createFont(0, fontStream);
            }
            log.info("{} \u5b57\u4f53 \u5df2\u52a0\u8f7d", (Object)font.getFontName());
            ORIGIN_FONT_MAP.putIfAbsent(path, font);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font processFont(Font originFont, int fontStyle, int size) {
        String string = String.format(FONT_KEY_FORMAT, originFont.getFontName(), fontStyle, size);
        Font font = NEW_FONT_MAP.get(string);
        if (font != null) {
            return font;
        }
        Map<String, Font> map = NEW_FONT_MAP;
        synchronized (map) {
            font = NEW_FONT_MAP.get(string);
            if (font != null) {
                return font;
            }
            font = originFont.deriveFont(fontStyle, size);
            NEW_FONT_MAP.put(string, font);
        }
        return font;
    }
}

