/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tech.sdk.utils;

import com.timevale.tech.sdk.utils.Base64;
import esign.utils.coding.Coder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Util {
    private static Logger log = LoggerFactory.getLogger(MD5Util.class);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String md5(String srcStr) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(srcStr.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (Integer.toHexString(0xFF & byArray[i2]).length() == 1) {
                    stringBuffer.append("0").append(Integer.toHexString(0xFF & byArray[i2]));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(0xFF & byArray[i2]));
            }
        }
        catch (Exception exception) {
            log.error("[MD5Util]", (Throwable)exception);
        }
        return stringBuffer.toString();
    }

    public static String md5Base64(String srcStr) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(srcStr.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            return Coder.BASE64.encode(byArray);
        }
        catch (Exception exception) {
            log.error("[MD5Util]", (Throwable)exception);
            return stringBuffer.toString();
        }
    }

    public static String md5(byte[] src) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(src);
            byte[] byArray = messageDigest.digest();
            string = Coder.BASE64.encode(byArray);
        }
        catch (Exception exception) {
            log.error("[MD5Util]", (Throwable)exception);
        }
        return string;
    }

    private static String toHexString(byte[] b2) {
        StringBuilder stringBuilder = new StringBuilder(b2.length * 2);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            stringBuilder.append(HEX_DIGITS[(b2[i2] & 0xF0) >>> 4]);
            stringBuilder.append(HEX_DIGITS[b2[i2] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String Bit32(String SourceString) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(SourceString.getBytes());
        byte[] byArray = messageDigest.digest();
        return MD5Util.toHexString(byArray);
    }

    public static String fileMD5(String filePath) {
        byte[] byArray = MD5Util.getFileMD5Bytes1282(filePath);
        if (byArray == null) {
            return null;
        }
        return Base64.getUrlEncoder().encodeToString(byArray);
    }

    public static byte[] getFileMD5Bytes1282(String filePath) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            File file = new File(filePath);
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = new byte[1024];
            int n2 = -1;
            while ((n2 = fileInputStream.read(byArray2, 0, 1024)) != -1) {
                messageDigest.update(byArray2, 0, n2);
            }
            byArray = messageDigest.digest();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("file not exist");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error("NoSuchAlgorithmException");
        }
        catch (IOException iOException) {
            log.error("IOException error {}", (Throwable)iOException);
        }
        return byArray;
    }
}

