/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.Wrapper;
import com.timevale.tgtext.bouncycastle.crypto.engines.GOST28147Engine;
import com.timevale.tgtext.bouncycastle.crypto.macs.GOST28147Mac;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithSBox;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithUKM;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)cipherParameters;
            cipherParameters = ((ParametersWithRandom)cipherParameters2).getParameters();
        }
        cipherParameters2 = (ParametersWithUKM)cipherParameters;
        this.cipher.init(bl2, ((ParametersWithUKM)cipherParameters2).getParameters());
        KeyParameter keyParameter = ((ParametersWithUKM)cipherParameters2).getParameters() instanceof ParametersWithSBox ? (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)cipherParameters2).getParameters()).getParameters() : (KeyParameter)((ParametersWithUKM)cipherParameters2).getParameters();
        this.mac.init(new ParametersWithIV(keyParameter, ((ParametersWithUKM)cipherParameters2).getUKM()));
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        this.mac.update(byArray, n2, n3);
        byte[] byArray2 = new byte[n3 + this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        this.mac.doFinal(byArray2, n3);
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[n3 - this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[this.mac.getMacSize()];
        System.arraycopy(byArray, n2 + n3 - 4, byArray4, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray2;
    }
}

