/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import java.util.Vector;

class DTLSReassembler {
    private short msg_type;
    private byte[] body;
    private Vector missing = new Vector();

    DTLSReassembler(short s2, int n2) {
        this.msg_type = s2;
        this.body = new byte[n2];
        this.missing.addElement(new Range(0, n2));
    }

    short getMsgType() {
        return this.msg_type;
    }

    byte[] getBodyIfComplete() {
        return this.missing.isEmpty() ? this.body : null;
    }

    void contributeFragment(short s2, int n2, byte[] byArray, int n3, int n4, int n5) {
        Range range;
        int n6 = n4 + n5;
        if (this.msg_type != s2 || this.body.length != n2 || n6 > n2) {
            return;
        }
        if (n5 == 0) {
            Range range2;
            if (n4 == 0 && !this.missing.isEmpty() && (range2 = (Range)this.missing.firstElement()).getEnd() == 0) {
                this.missing.removeElementAt(0);
            }
            return;
        }
        for (int i2 = 0; i2 < this.missing.size() && (range = (Range)this.missing.elementAt(i2)).getStart() < n6; ++i2) {
            if (range.getEnd() <= n4) continue;
            int n7 = Math.max(range.getStart(), n4);
            int n8 = Math.min(range.getEnd(), n6);
            int n9 = n8 - n7;
            System.arraycopy(byArray, n3 + n7 - n4, this.body, n7, n9);
            if (n7 == range.getStart()) {
                if (n8 == range.getEnd()) {
                    this.missing.removeElementAt(i2--);
                    continue;
                }
                range.setStart(n8);
                continue;
            }
            if (n8 != range.getEnd()) {
                this.missing.insertElementAt(new Range(n8, range.getEnd()), ++i2);
            }
            range.setEnd(n7);
        }
    }

    void reset() {
        this.missing.removeAllElements();
        this.missing.addElement(new Range(0, this.body.length));
    }

    private static class Range {
        private int start;
        private int end;

        Range(int n2, int n3) {
            this.start = n2;
            this.end = n3;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n2) {
            this.start = n2;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n2) {
            this.end = n2;
        }
    }
}

