/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl.jcajce;

import com.timevale.tgtext.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.util.JcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.openssl.PEMEncryptor;
import com.timevale.tgtext.bouncycastle.openssl.PEMException;
import com.timevale.tgtext.bouncycastle.openssl.jcajce.PEMUtilities;
import java.security.Provider;
import java.security.SecureRandom;

public class JcePEMEncryptorBuilder {
    private final String algorithm;
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private SecureRandom random;

    public JcePEMEncryptorBuilder(String string) {
        this.algorithm = string;
    }

    public JcePEMEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMEncryptorBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JcePEMEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PEMEncryptor build(final char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        int n2 = this.algorithm.startsWith("AES-") ? 16 : 8;
        final byte[] byArray = new byte[n2];
        this.random.nextBytes(byArray);
        return new PEMEncryptor(){

            @Override
            public String getAlgorithm() {
                return JcePEMEncryptorBuilder.this.algorithm;
            }

            @Override
            public byte[] getIV() {
                return byArray;
            }

            @Override
            public byte[] encrypt(byte[] byArray2) throws PEMException {
                return PEMUtilities.crypt(true, JcePEMEncryptorBuilder.this.helper, byArray2, cArray, JcePEMEncryptorBuilder.this.algorithm, byArray);
            }
        };
    }
}

