/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] byArray, Digest digest, int n2) {
        this.w = n2;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        int n3 = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)n3 / (double)n2);
        this.checksumsize = this.getLog((this.messagesize << n2) + 1);
        this.keysize = this.messagesize + (int)Math.ceil((double)this.checksumsize / (double)n2);
        this.privateKeyOTS = new byte[this.keysize][this.mdsize];
        byte[] byArray2 = new byte[this.mdsize];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        for (int i2 = 0; i2 < this.keysize; ++i2) {
            this.privateKeyOTS[i2] = this.gmssRandom.nextSeed(byArray2);
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] byArray = new byte[this.keysize * this.mdsize];
        byte[] byArray2 = new byte[this.mdsize];
        int n2 = 1 << this.w;
        for (int i2 = 0; i2 < this.keysize; ++i2) {
            this.messDigestOTS.update(this.privateKeyOTS[i2], 0, this.privateKeyOTS[i2].length);
            byArray2 = new byte[this.messDigestOTS.getDigestSize()];
            this.messDigestOTS.doFinal(byArray2, 0);
            for (int i3 = 2; i3 < n2; ++i3) {
                this.messDigestOTS.update(byArray2, 0, byArray2.length);
                byArray2 = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(byArray2, 0);
            }
            System.arraycopy(byArray2, 0, byArray, this.mdsize * i2, this.mdsize);
        }
        this.messDigestOTS.update(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(byArray3, 0);
        return byArray3;
    }

    public byte[] getSignature(byte[] byArray) {
        byte[] byArray2;
        block23: {
            long l2;
            int n2;
            int n3;
            long l3;
            int n4;
            int n5;
            int n6;
            int n7;
            byte[] byArray3;
            block24: {
                long l4;
                int n8;
                int n9;
                block22: {
                    int n10;
                    byArray2 = new byte[this.keysize * this.mdsize];
                    byArray3 = new byte[this.mdsize];
                    n7 = 0;
                    n6 = 0;
                    n9 = 0;
                    this.messDigestOTS.update(byArray, 0, byArray.length);
                    byArray3 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray3, 0);
                    if (8 % this.w != 0) break block22;
                    int n11 = 8 / this.w;
                    int n12 = (1 << this.w) - 1;
                    byte[] byArray4 = new byte[this.mdsize];
                    for (n10 = 0; n10 < byArray3.length; ++n10) {
                        for (int i2 = 0; i2 < n11; ++i2) {
                            n6 += n9;
                            System.arraycopy(this.privateKeyOTS[n7], 0, byArray4, 0, this.mdsize);
                            for (n9 = byArray3[n10] & n12; n9 > 0; --n9) {
                                this.messDigestOTS.update(byArray4, 0, byArray4.length);
                                byArray4 = new byte[this.messDigestOTS.getDigestSize()];
                                this.messDigestOTS.doFinal(byArray4, 0);
                            }
                            System.arraycopy(byArray4, 0, byArray2, n7 * this.mdsize, this.mdsize);
                            byArray3[n10] = (byte)(byArray3[n10] >>> this.w);
                            ++n7;
                        }
                    }
                    n6 = (this.messagesize << this.w) - n6;
                    for (n10 = 0; n10 < this.checksumsize; n10 += this.w) {
                        System.arraycopy(this.privateKeyOTS[n7], 0, byArray4, 0, this.mdsize);
                        for (n9 = n6 & n12; n9 > 0; --n9) {
                            this.messDigestOTS.update(byArray4, 0, byArray4.length);
                            byArray4 = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(byArray4, 0);
                        }
                        System.arraycopy(byArray4, 0, byArray2, n7 * this.mdsize, this.mdsize);
                        n6 >>>= this.w;
                        ++n7;
                    }
                    break block23;
                }
                if (this.w >= 8) break block24;
                int n13 = this.mdsize / this.w;
                int n14 = (1 << this.w) - 1;
                byte[] byArray5 = new byte[this.mdsize];
                int n15 = 0;
                for (n8 = 0; n8 < n13; ++n8) {
                    int n16;
                    l4 = 0L;
                    for (n16 = 0; n16 < this.w; ++n16) {
                        l4 ^= (long)((byArray3[n15] & 0xFF) << (n16 << 3));
                        ++n15;
                    }
                    for (n16 = 0; n16 < 8; ++n16) {
                        n6 += n9;
                        System.arraycopy(this.privateKeyOTS[n7], 0, byArray5, 0, this.mdsize);
                        for (n9 = (int)(l4 & (long)n14); n9 > 0; --n9) {
                            this.messDigestOTS.update(byArray5, 0, byArray5.length);
                            byArray5 = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(byArray5, 0);
                        }
                        System.arraycopy(byArray5, 0, byArray2, n7 * this.mdsize, this.mdsize);
                        l4 >>>= this.w;
                        ++n7;
                    }
                }
                n13 = this.mdsize % this.w;
                l4 = 0L;
                for (n8 = 0; n8 < n13; ++n8) {
                    l4 ^= (long)((byArray3[n15] & 0xFF) << (n8 << 3));
                    ++n15;
                }
                n13 <<= 3;
                for (n8 = 0; n8 < n13; n8 += this.w) {
                    n6 += n9;
                    System.arraycopy(this.privateKeyOTS[n7], 0, byArray5, 0, this.mdsize);
                    for (n9 = (int)(l4 & (long)n14); n9 > 0; --n9) {
                        this.messDigestOTS.update(byArray5, 0, byArray5.length);
                        byArray5 = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(byArray5, 0);
                    }
                    System.arraycopy(byArray5, 0, byArray2, n7 * this.mdsize, this.mdsize);
                    l4 >>>= this.w;
                    ++n7;
                }
                n6 = (this.messagesize << this.w) - n6;
                for (n8 = 0; n8 < this.checksumsize; n8 += this.w) {
                    System.arraycopy(this.privateKeyOTS[n7], 0, byArray5, 0, this.mdsize);
                    for (n9 = n6 & n14; n9 > 0; --n9) {
                        this.messDigestOTS.update(byArray5, 0, byArray5.length);
                        byArray5 = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(byArray5, 0);
                    }
                    System.arraycopy(byArray5, 0, byArray2, n7 * this.mdsize, this.mdsize);
                    n6 >>>= this.w;
                    ++n7;
                }
                break block23;
            }
            if (this.w >= 57) break block23;
            int n17 = (this.mdsize << 3) - this.w;
            int n18 = (1 << this.w) - 1;
            byte[] byArray6 = new byte[this.mdsize];
            int n19 = 0;
            while (n19 <= n17) {
                n5 = n19 >>> 3;
                n4 = n19 % 8;
                int n20 = (n19 += this.w) + 7 >>> 3;
                l3 = 0L;
                n3 = 0;
                for (n2 = n5; n2 < n20; ++n2) {
                    l3 ^= (long)((byArray3[n2] & 0xFF) << (n3 << 3));
                    ++n3;
                }
                n6 = (int)((long)n6 + l2);
                System.arraycopy(this.privateKeyOTS[n7], 0, byArray6, 0, this.mdsize);
                for (l2 = (l3 >>>= n4) & (long)n18; l2 > 0L; --l2) {
                    this.messDigestOTS.update(byArray6, 0, byArray6.length);
                    byArray6 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray6, 0);
                }
                System.arraycopy(byArray6, 0, byArray2, n7 * this.mdsize, this.mdsize);
                ++n7;
            }
            n5 = n19 >>> 3;
            if (n5 < this.mdsize) {
                n4 = n19 % 8;
                l3 = 0L;
                n3 = 0;
                for (n2 = n5; n2 < this.mdsize; ++n2) {
                    l3 ^= (long)((byArray3[n2] & 0xFF) << (n3 << 3));
                    ++n3;
                }
                n6 = (int)((long)n6 + l2);
                System.arraycopy(this.privateKeyOTS[n7], 0, byArray6, 0, this.mdsize);
                for (l2 = (l3 >>>= n4) & (long)n18; l2 > 0L; --l2) {
                    this.messDigestOTS.update(byArray6, 0, byArray6.length);
                    byArray6 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray6, 0);
                }
                System.arraycopy(byArray6, 0, byArray2, n7 * this.mdsize, this.mdsize);
                ++n7;
            }
            n6 = (this.messagesize << this.w) - n6;
            for (n2 = 0; n2 < this.checksumsize; n2 += this.w) {
                System.arraycopy(this.privateKeyOTS[n7], 0, byArray6, 0, this.mdsize);
                for (l2 = (long)(n6 & n18); l2 > 0L; --l2) {
                    this.messDigestOTS.update(byArray6, 0, byArray6.length);
                    byArray6 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray6, 0);
                }
                System.arraycopy(byArray6, 0, byArray2, n7 * this.mdsize, this.mdsize);
                n6 >>>= this.w;
                ++n7;
            }
        }
        return byArray2;
    }

    public int getLog(int n2) {
        int n3 = 1;
        int n4 = 2;
        while (n4 < n2) {
            n4 <<= 1;
            ++n3;
        }
        return n3;
    }
}

