/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abw;
    protected Alignment abx = Alignment.LEFT;
    protected DrawInterface aby;
    protected char abz = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abw = position;
        this.aby = leader;
        this.abx = alignment;
        this.abz = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.DW(), tabStop.DY(), tabStop.DX(), tabStop.DZ());
    }

    public float DW() {
        return this.abw;
    }

    public void an(float f2) {
        this.abw = f2;
    }

    public Alignment DX() {
        return this.abx;
    }

    public void a(Alignment alignment) {
        this.abx = alignment;
    }

    public DrawInterface DY() {
        return this.aby;
    }

    public void a(DrawInterface drawInterface) {
        this.aby = drawInterface;
    }

    public char DZ() {
        return this.abz;
    }

    public void k(char c2) {
        this.abz = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abw;
        float f6 = f3 - f2;
        switch (this.abx) {
            case RIGHT: {
                if (f2 + f6 < this.abw) {
                    f5 = this.abw - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abw) {
                    f5 = this.abw - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abw) {
                        f5 = this.abw - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abw ? this.abw - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

