/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.f;

import com.timevale.tgtext.text.pdf.f.a;

public final class b {
    public final int width;
    public final int height;
    public final int rowSize;
    public final int[] bits;

    public b(int n2) {
        this(n2, n2);
    }

    public b(int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = n2;
        this.height = n3;
        int n4 = n2 >> 5;
        if ((n2 & 0x1F) != 0) {
            ++n4;
        }
        this.rowSize = n4;
        this.bits = new int[n4 * n3];
    }

    public boolean get(int x2, int y2) {
        int n2 = y2 * this.rowSize + (x2 >> 5);
        return (this.bits[n2] >>> (x2 & 0x1F) & 1) != 0;
    }

    public void set(int x2, int y2) {
        int n2;
        int n3 = n2 = y2 * this.rowSize + (x2 >> 5);
        this.bits[n3] = this.bits[n3] | 1 << (x2 & 0x1F);
    }

    public void flip(int x2, int y2) {
        int n2;
        int n3 = n2 = y2 * this.rowSize + (x2 >> 5);
        this.bits[n3] = this.bits[n3] ^ 1 << (x2 & 0x1F);
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public void setRegion(int left, int top, int width, int height) {
        if (top < 0 || left < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (height < 1 || width < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int n2 = left + width;
        int n3 = top + height;
        if (n3 > this.height || n2 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int i2 = top; i2 < n3; ++i2) {
            int n4 = i2 * this.rowSize;
            for (int i3 = left; i3 < n2; ++i3) {
                int n5 = n4 + (i3 >> 5);
                this.bits[n5] = this.bits[n5] | 1 << (i3 & 0x1F);
            }
        }
    }

    public a a(int n2, a a2) {
        if (a2 == null || a2.getSize() < this.width) {
            a2 = new a(this.width);
        }
        int n3 = n2 * this.rowSize;
        for (int i2 = 0; i2 < this.rowSize; ++i2) {
            a2.setBulk(i2 << 5, this.bits[n3 + i2]);
        }
        return a2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDimension() {
        if (this.width != this.height) {
            throw new RuntimeException("Can't call getDimension() on a non-square matrix");
        }
        return this.width;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.height * (this.width + 1));
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                stringBuffer.append(this.get(i3, i2) ? "X " : "  ");
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

