/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.tech.bean.bean.AccountInfoBean;
import com.timevale.esign.paas.tech.bean.httpvo.GetAccountInfoResult;
import com.timevale.esign.paas.tech.bean.model.AccountAddModel;
import com.timevale.esign.paas.tech.bean.model.AccountDeleteModel;
import com.timevale.esign.paas.tech.bean.model.AccountQueryByNoModel;
import com.timevale.esign.paas.tech.bean.model.AccountQueryModel;
import com.timevale.esign.paas.tech.bean.model.AccountUpdateModel;
import com.timevale.esign.paas.tech.bean.request.OrganizeParam;
import com.timevale.esign.paas.tech.bean.request.PersonParam;
import com.timevale.esign.paas.tech.bean.request.QueryAccountInfoParam;
import com.timevale.esign.paas.tech.bean.request.UpdateOrganizeParam;
import com.timevale.esign.paas.tech.bean.request.UpdatePersonParam;
import com.timevale.esign.paas.tech.bean.result.AccountInfoAndCertResult;
import com.timevale.esign.paas.tech.bean.result.AccountInfoResult;
import com.timevale.esign.paas.tech.bean.result.AddAccountResult;
import com.timevale.esign.paas.tech.bean.result.Result;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.common.Convertor;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.AccountTypeEnum;
import com.timevale.esign.paas.tech.enums.AllIdNoTypeEnum;
import com.timevale.esign.paas.tech.service.AccountService;
import com.timevale.esign.paas.tech.service.a.a;
import com.timevale.esign.paas.tech.util.AesUtil;
import com.timevale.esign.paas.tech.util.RequestUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.seal.sdk.util.StringUtils;
import esign.utils.JsonHelper;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class c
extends a
implements AccountService {
    private static Logger log = LoggerFactory.getLogger(c.class);

    public c() {
    }

    public c(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public AccountInfoResult getAccountInfoSuccessful(String accountId, boolean encrypt) throws SuperException {
        AccountInfoResult accountInfoResult = this.getAccountInfo(accountId, encrypt);
        if (!RequestUtil.isRequestSuccess(accountInfoResult)) {
            log.error("query account name by uid failed. account: {} ", (Object)accountId);
            throw ErrorsDiscriptor.AccountInfo.e();
        }
        return accountInfoResult;
    }

    @Override
    public AccountInfoResult getAccountInfo(String accountId, boolean encrypt) {
        if (StringUtils.isBlank(accountId)) {
            return ResultUtil.failed(1025, AccountInfoResult.class);
        }
        try {
            AccountQueryModel accountQueryModel = (AccountQueryModel)this.uy().getContext().a(InterfaceKey.QUERY_ACCOUNT);
            accountQueryModel.setAccountUid(accountId);
            accountQueryModel.setEncrypt(encrypt);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountQueryModel);
            GetAccountInfoResult getAccountInfoResult = JsonHelper.fromJson(jsonObject, GetAccountInfoResult.class);
            if (0 != getAccountInfoResult.getErrCode()) {
                log.error("getAccountInfo failed.errCode:{},errMsg:{}", (Object)getAccountInfoResult.getErrCode(), (Object)getAccountInfoResult.getMsg());
                return ResultUtil.failed(getAccountInfoResult, AccountInfoResult.class);
            }
            getAccountInfoResult.decrypt(this.uy().getContext().up().getProjectSecret());
            return this.a(getAccountInfoResult);
        }
        catch (Exception exception) {
            log.error("getAccountInfo failed.", (Throwable)exception);
            return ResultUtil.failed(exception, AccountInfoResult.class);
        }
    }

    @Override
    public AddAccountResult addAccount(PersonParam person) {
        try {
            person.check();
            AccountAddModel accountAddModel = (AccountAddModel)this.uy().getContext().a(InterfaceKey.ADD_ACCOUNT);
            if (Boolean.TRUE.equals(person.getEncrypt())) {
                accountAddModel.setEncrypt(person.getEncrypt());
                accountAddModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(Convertor.convert(person)), this.uy().getContext().up().getProjectSecret()));
            } else {
                accountAddModel.setAccount(Convertor.convert(person));
            }
            accountAddModel.setIdentityAuthId(person.getIdentityAuthId());
            accountAddModel.setRealnameEvidencePointId(person.getRealnameEvidencePointId());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountAddModel);
            AddAccountResult addAccountResult = JsonHelper.fromJson(jsonObject, AddAccountResult.class);
            if (0 != addAccountResult.getErrCode()) {
                log.error("addAccount person failed,errMsg:{}", (Object)addAccountResult.getMsg());
                return ResultUtil.failed(addAccountResult, AddAccountResult.class);
            }
            return addAccountResult;
        }
        catch (SuperException superException) {
            log.error("addAccount person failed.", (Throwable)superException);
            return ResultUtil.failed(superException, AddAccountResult.class);
        }
        catch (Exception exception) {
            log.error("addAccount person failed.", (Throwable)exception);
            return ResultUtil.failed(exception, AddAccountResult.class);
        }
    }

    @Override
    public AddAccountResult addAccount(OrganizeParam organize) {
        try {
            organize.check();
            AccountAddModel accountAddModel = (AccountAddModel)this.uy().getContext().a(InterfaceKey.ADD_ACCOUNT);
            if (Boolean.TRUE.equals(organize.getEncrypt())) {
                accountAddModel.setEncrypt(organize.getEncrypt());
                accountAddModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(Convertor.convert(organize)), this.uy().getContext().up().getProjectSecret()));
            } else {
                accountAddModel.setAccount(Convertor.convert(organize));
            }
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountAddModel);
            AddAccountResult addAccountResult = JsonHelper.fromJson(jsonObject, AddAccountResult.class);
            if (0 != addAccountResult.getErrCode()) {
                log.error("addAccount organize failed,errMsg:{}", (Object)addAccountResult.getMsg());
                return ResultUtil.failed(addAccountResult, AddAccountResult.class);
            }
            return addAccountResult;
        }
        catch (SuperException superException) {
            log.error("addAccount organize failed.", (Throwable)superException);
            return ResultUtil.failed(superException, AddAccountResult.class);
        }
        catch (Exception exception) {
            log.error("addAccount organize failed.", (Throwable)exception);
            return ResultUtil.failed(exception, AddAccountResult.class);
        }
    }

    @Override
    public Result updateAccount(UpdatePersonParam updatePerson) {
        try {
            updatePerson.check();
            AccountUpdateModel accountUpdateModel = (AccountUpdateModel)this.uy().getContext().a(InterfaceKey.UPDATE_ACCOUNT);
            AccountUpdateModel.Account account = Convertor.convert(updatePerson);
            if (Boolean.TRUE.equals(updatePerson.getEncrypt())) {
                accountUpdateModel.setEncrypt(updatePerson.getEncrypt());
                accountUpdateModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(account), this.uy().getContext().up().getProjectSecret()));
            } else {
                accountUpdateModel.setAccount(account);
            }
            accountUpdateModel.setIdentityAuthId(updatePerson.getIdentityAuthId());
            accountUpdateModel.setRealnameEvidencePointId(updatePerson.getRealnameEvidencePointId());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountUpdateModel);
            Result result = JsonHelper.fromJson(jsonObject, Result.class);
            if (0 != result.getErrCode()) {
                log.error("update person info failed.errCode:{},errMsg:{}.", (Object)result.getErrCode(), (Object)result.getErrCode());
                return ResultUtil.failed(result, Result.class);
            }
            return result;
        }
        catch (SuperException superException) {
            log.error("update person failed.", (Throwable)superException);
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.error("update person failed.", (Throwable)exception);
            return ResultUtil.failed(exception, Result.class);
        }
    }

    @Override
    public Result updateAccount(UpdateOrganizeParam updateOrganize) {
        try {
            updateOrganize.check();
            AccountUpdateModel accountUpdateModel = (AccountUpdateModel)this.uy().getContext().a(InterfaceKey.UPDATE_ACCOUNT);
            AccountUpdateModel.Account account = Convertor.convert(updateOrganize);
            if (Boolean.TRUE.equals(updateOrganize.getEncrypt())) {
                accountUpdateModel.setEncrypt(updateOrganize.getEncrypt());
                accountUpdateModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(account), this.uy().getContext().up().getProjectSecret()));
            } else {
                accountUpdateModel.setAccount(account);
            }
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountUpdateModel);
            Result result = JsonHelper.fromJson(jsonObject, Result.class);
            if (0 != result.getErrCode()) {
                log.error("updateOrganize info failed.errCode:{},errMsg:{}.", (Object)result.getErrCode(), (Object)result.getErrCode());
                return ResultUtil.failed(result, Result.class);
            }
            return result;
        }
        catch (SuperException superException) {
            log.error("updateOrganize failed.", (Throwable)superException);
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.error("updateOrganize failed.", (Throwable)exception);
            return ResultUtil.failed(exception, Result.class);
        }
    }

    @Override
    public Result deleteAccount(String accountId) {
        try {
            ValidationUtil.check(StringUtils.isBlank(accountId), ErrorException.PARAM_ERROR.e("accountId\u4e3a\u7a7a"));
            AccountDeleteModel accountDeleteModel = (AccountDeleteModel)this.uy().getContext().a(InterfaceKey.DEL_ACCOUNT);
            accountDeleteModel.setAccountUid(accountId);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountDeleteModel);
            Result result = JsonHelper.fromJson(jsonObject, Result.class);
            if (0 != result.getErrCode()) {
                log.error("deleteAccount failed,errMsg:{}", (Object)result.getMsg());
                return result;
            }
            return result;
        }
        catch (SuperException superException) {
            log.error("deleteAccount failed.", (Throwable)superException);
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.error("deleteAccount failed.", (Throwable)exception);
            return ResultUtil.failed(exception, Result.class);
        }
    }

    @Override
    public AccountInfoResult getAccountInfo(QueryAccountInfoParam param) {
        try {
            param.check();
            AccountQueryByNoModel accountQueryByNoModel = (AccountQueryByNoModel)this.uy().getContext().a(InterfaceKey.QUERY_ACCOUNT_BY_NO);
            AccountQueryByNoModel.QueryAccount queryAccount = new AccountQueryByNoModel.QueryAccount();
            queryAccount.setIdNo(param.getIdNo());
            queryAccount.setIdNoType(param.getIdNoType().val());
            queryAccount.setAccountType(param.getType().type());
            if (Boolean.TRUE.equals(param.getEncrypt())) {
                accountQueryByNoModel.setEncrypt(param.getEncrypt());
                accountQueryByNoModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(queryAccount), this.uy().getContext().up().getProjectSecret()));
            } else {
                accountQueryByNoModel.setAccount(queryAccount);
            }
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountQueryByNoModel);
            GetAccountInfoResult getAccountInfoResult = JsonHelper.fromJson(jsonObject, GetAccountInfoResult.class);
            if (0 != getAccountInfoResult.getErrCode()) {
                log.error("getAccountInfo failed,errMsg:{}", (Object)getAccountInfoResult.getMsg());
                return ResultUtil.failed(getAccountInfoResult, AccountInfoResult.class);
            }
            getAccountInfoResult.decrypt(this.uy().getContext().up().getProjectSecret());
            return this.a(getAccountInfoResult);
        }
        catch (SuperException superException) {
            log.error("getAccountInfo failed.", (Throwable)superException);
            return ResultUtil.failed(superException, AccountInfoResult.class);
        }
        catch (Exception exception) {
            log.error("getAccountInfo failed.", (Throwable)exception);
            return ResultUtil.failed(exception, AccountInfoResult.class);
        }
    }

    private AccountInfoAndCertResult a(GetAccountInfoResult getAccountInfoResult) {
        AccountInfoAndCertResult accountInfoAndCertResult = new AccountInfoAndCertResult();
        AccountInfoBean accountInfoBean = getAccountInfoResult.getAccountInfo();
        accountInfoAndCertResult.setAccountId(accountInfoBean.getAccountUid());
        accountInfoAndCertResult.setName(accountInfoBean.getName());
        accountInfoAndCertResult.setIdNo(accountInfoBean.getIdNo());
        accountInfoAndCertResult.setIdNoType(AllIdNoTypeEnum.getByVal(accountInfoBean.getIdNoType()));
        accountInfoAndCertResult.setAccountType(AccountTypeEnum.getByType(accountInfoBean.getAccountType()));
        accountInfoAndCertResult.setCert(accountInfoBean.getCert());
        return accountInfoAndCertResult;
    }
}

