/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.tech.bean.bean.CertInfo;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import esign.utils.Base64;
import esign.utils.security.provider.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CommonCertUtil {
    public static CertInfo getCertInfo(byte[] certBytes) {
        try {
            CertInfo certInfo = new CertInfo();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = null;
            aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            certInfo.setSerialNumber(x509CertificateStructure.getSerialNumber().getValue().toString(16));
            certInfo.setVersion(x509CertificateStructure.getVersion() + "");
            certInfo.setIssue(x509CertificateStructure.getIssuer().toString());
            certInfo.setSubject(x509CertificateStructure.getSubject().toString());
            certInfo.setStartTime(x509CertificateStructure.getStartDate().getDate());
            certInfo.setEndTime(x509CertificateStructure.getEndDate().getDate());
            certInfo.setIssue_cn(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "CN="));
            certInfo.setIssue_email(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "EMAIL="));
            certInfo.setIssue_givenname(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "GIVENNAME="));
            certInfo.setIssue_ou(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "OU="));
            certInfo.setIssue_c(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "C="));
            certInfo.setIssue_o(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "O="));
            certInfo.setIssue_l(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "L="));
            certInfo.setIssue_s(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getIssuer().toString(), "ST="));
            certInfo.setSubject_cn(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "CN="));
            certInfo.setSubject_email(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "EMAIL="));
            certInfo.setSubject_phone(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "TelephoneNumber="));
            certInfo.setSubject_givenname(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "GIVENNAME="));
            certInfo.setSubject_ou(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "OU="));
            certInfo.setSubject_c(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "C="));
            certInfo.setSubject_o(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "O="));
            certInfo.setSubject_l(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "L="));
            certInfo.setSubject_s(CommonCertUtil.getInfoFromDn(x509CertificateStructure.getSubject().toString(), "ST="));
            certInfo.setSignalg(x509CertificateStructure.getSignatureAlgorithm().getAlgorithm().getId());
            SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateStructure.getSubjectPublicKeyInfo();
            byte[] byArray = x509CertificateStructure.getSubjectPublicKeyInfo().getPublicKeyData().getEncoded();
            String string = Base64.encode(byArray);
            certInfo.setPubkey(string);
            X509Extensions x509Extensions = x509CertificateStructure.getTBSCertificate().getExtensions();
            certInfo.setExt_crldistributionpo(CommonCertUtil.getCrlDistributionPoints(x509Extensions));
            return certInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String getCrlDistributionPoints(X509Extensions ext) throws IOException {
        String string = "";
        byte[] byArray = CommonCertUtil.getExtensionBytes(X509Extensions.CRLDistributionPoints.getId(), ext);
        if (byArray == null) {
            return string;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        byte[] byArray2 = aSN1InputStream.readObject().getEncoded();
        ASN1InputStream aSN1InputStream2 = new ASN1InputStream(new ByteArrayInputStream(byArray2));
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance(aSN1InputStream2.readObject());
        for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName == null || distributionPointName.getType() != 0) continue;
            GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
            for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
                if (generalNameArray[i2].getTagNo() != 6) continue;
                String string2 = DERIA5String.getInstance(generalNameArray[i2].getName()).getString();
                string = string + string2;
            }
        }
        return string;
    }

    private static void getPolicyInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)seq.getObjectAt(0);
            System.out.println("\u8bc1\u4e66\u7b56\u7565\u6807\u8bc6:" + dERObjectIdentifier.getId());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)seq.getObjectAt(1);
            for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                CommonCertUtil.getPolicyQualifierInfo((ASN1Sequence)aSN1Sequence.getObjectAt(i2));
            }
        } else {
            System.out.println("\u89e3\u6790\u7b56\u7565\u58f0\u660e\u65f6\u51fa\u9519!");
        }
    }

    private static void getPolicyQualifierInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)seq.getObjectAt(0);
            System.out.println("\u7b56\u7565\u58f0\u660e\u6807\u8bc6:" + dERObjectIdentifier.getId());
            DERIA5String dERIA5String = (DERIA5String)seq.getObjectAt(1);
            System.out.println("\u58f0\u660e\u5185\u5bb9:" + dERIA5String.getString());
        }
    }

    private static byte[] getExtensionBytes(String oid, X509Extensions exts) {
        X509Extension x509Extension;
        if (exts != null && (x509Extension = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            return x509Extension.getValue().getOctets();
        }
        return null;
    }

    public static String getInfoFromDn(String dn2, String key) {
        String string = "";
        String[] stringArray = dn2.split(",");
        if (stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
                if (!stringArray[i2].toUpperCase().contains(key.toUpperCase())) continue;
                string = stringArray[i2].substring(stringArray[i2].indexOf(key.toUpperCase()) + key.length(), stringArray[i2].length());
            }
        }
        return string;
    }

    static {
        Provider.BC.install();
    }
}

