/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityUtils.class);
    private static byte[] Wi = new byte[17];
    private static final byte fPart = 6;
    private static final byte fMod = 11;
    private static final byte oldIDLen = 15;
    private static final byte newIDLen = 18;
    private static final String yearFlag = "19";
    private static final String CheckCode = "10X98765432";
    private static final String idNo15Reg = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
    private static final String idNo18Reg = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|x|X){1}$";
    private static boolean newIDFlag = false;

    private static void setWiBuffer() {
        for (int i2 = 0; i2 < Wi.length; ++i2) {
            int n2 = (int)Math.pow(2.0, Wi.length - i2);
            IdentityUtils.Wi[i2] = (byte)(n2 % 11);
        }
    }

    private static String getCheckFlag(String idCard) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 17; ++n2) {
            n3 += Integer.parseInt(idCard.substring(n2, n2 + 1)) * Wi[n2];
        }
        n2 = (byte)(n3 % 11);
        return CheckCode.substring(n2, n2 + 1);
    }

    private static boolean checkLength(String idCard) {
        boolean bl2;
        boolean bl3 = bl2 = idCard.length() == 15 || idCard.length() == 18;
        if (bl2) {
            newIDFlag = idCard.length() == 18;
        }
        return bl2;
    }

    private static String getIDDate(String idCard) {
        String string = "";
        string = newIDFlag ? idCard.substring(6, 14) : yearFlag + idCard.substring(6, 12);
        return string;
    }

    public static void main(String[] args) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("zh", "CN"));
        String string = "2024-01-30";
        System.out.println(dateFormat.format(new Date()));
        try {
            Date date = dateFormat.parse(string);
            System.out.println(dateFormat.format(new Date()));
        }
        catch (ParseException parseException) {
            LOG.warn("error datasource  for data:{} to parse date");
        }
    }

    private static boolean checkDate(String dateSource) {
        String string = dateSource.substring(0, 4) + "-" + dateSource.substring(4, 6) + "-" + dateSource.substring(6, 8);
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("zh", "CN"));
        dateFormat.setLenient(false);
        try {
            Date date = dateFormat.parse(string);
            return date != null;
        }
        catch (ParseException parseException) {
            LOG.warn("error datasource  for data:{} to parse date", (Object)dateSource);
            return false;
        }
    }

    public static String getNewIDCard(String oldIDCard) {
        IdentityUtils.setWiBuffer();
        if (!IdentityUtils.checkIDCard(oldIDCard)) {
            return oldIDCard;
        }
        String string = oldIDCard.substring(0, 6);
        string = string + yearFlag;
        string = string + oldIDCard.substring(6, oldIDCard.length());
        String string2 = IdentityUtils.getCheckFlag(string);
        string = string + string2;
        return string;
    }

    public static String getOldIDCard(String newIDCard) {
        IdentityUtils.setWiBuffer();
        if (!IdentityUtils.checkIDCard(newIDCard)) {
            return newIDCard;
        }
        String string = newIDCard.substring(0, 6) + newIDCard.substring(6 + yearFlag.length(), newIDCard.length() - 1);
        return string;
    }

    public static boolean checkIDCard(String idCard) {
        IdentityUtils.setWiBuffer();
        if (!IdentityUtils.checkLength(idCard)) {
            LOG.warn("the idCard length exception for data:{}", (Object)idCard);
            return false;
        }
        String string = IdentityUtils.getIDDate(idCard);
        if (!IdentityUtils.checkDate(string)) {
            LOG.warn("the idCard date exception for data:{}", (Object)idCard);
            return false;
        }
        if (newIDFlag) {
            String string2;
            boolean bl2 = Pattern.compile(idNo18Reg).matcher(idCard).matches();
            if (!bl2) {
                return bl2;
            }
            String string3 = IdentityUtils.getCheckFlag(idCard);
            if (!string3.equals((string2 = idCard.substring(idCard.length() - 1, idCard.length())).toUpperCase())) {
                LOG.warn("the idCard valid exception for data:{}", (Object)idCard);
                return false;
            }
            return true;
        }
        return Pattern.compile(idNo15Reg).matcher(idCard).matches();
    }

    public IdentityUtils() {
        IdentityUtils.setWiBuffer();
    }
}

