/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.annotations.GwtIncompatible;
import com.timevale.guava.common.base.Equivalences;
import com.timevale.guava.common.base.Function;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.CustomConcurrentHashMap;
import com.timevale.guava.common.collect.GenericMapMaker;
import com.timevale.guava.common.collect.Interner;
import com.timevale.guava.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;

@Beta
public final class Interners {
    private Interners() {
    }

    public static <E> Interner<E> newStrongInterner() {
        final ConcurrentMap concurrentMap = new MapMaker().makeMap();
        return new Interner<E>(){

            @Override
            public E intern(E sample) {
                Object e2 = concurrentMap.putIfAbsent(Preconditions.checkNotNull(sample), sample);
                return e2 == null ? sample : e2;
            }
        };
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public static <E> Interner<E> newWeakInterner() {
        return new CustomInterner<Object>(new MapMaker().weakKeys());
    }

    public static <E> Function<E, E> asFunction(Interner<E> interner) {
        return new InternerFunction<E>(Preconditions.checkNotNull(interner));
    }

    private static class InternerFunction<E>
    implements Function<E, E> {
        private final Interner<E> interner;

        public InternerFunction(Interner<E> interner) {
            this.interner = interner;
        }

        @Override
        public E apply(E input) {
            return this.interner.intern(input);
        }

        public int hashCode() {
            return this.interner.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof InternerFunction) {
                InternerFunction internerFunction = (InternerFunction)other;
                return this.interner.equals(internerFunction.interner);
            }
            return false;
        }
    }

    private static class CustomInterner<E>
    implements Interner<E> {
        private final CustomConcurrentHashMap<E, Dummy> map;

        CustomInterner(GenericMapMaker<? super E, Object> mm) {
            this.map = mm.strongValues().keyEquivalence(Equivalences.equals()).makeCustomMap();
        }

        @Override
        public E intern(E sample) {
            Object object;
            do {
                CustomConcurrentHashMap.ReferenceEntry<E, Dummy> referenceEntry;
                if ((referenceEntry = this.map.getEntry(sample)) == null || (object = referenceEntry.getKey()) == null) continue;
                return object;
            } while ((object = this.map.putIfAbsent(sample, Dummy.VALUE)) != null);
            return sample;
        }

        private static enum Dummy {
            VALUE;

        }
    }
}

