/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.io;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.io.ByteStreams;
import com.timevale.guava.common.primitives.Ints;
import com.timevale.guava.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@Beta
public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream in) {
        super(Preconditions.checkNotNull(in));
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        ByteStreams.readFully(this, b2);
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        ByteStreams.readFully(this, b2, off, len);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return (int)this.in.skip(n2);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n2 = this.in.read();
        if (0 > n2) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        return Ints.fromBytes((byte)0, (byte)0, by3, by2);
    }

    @Override
    public int readInt() throws IOException {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        byte by4 = this.readAndCheckByte();
        byte by5 = this.readAndCheckByte();
        return Ints.fromBytes(by5, by4, by3, by2);
    }

    @Override
    public long readLong() throws IOException {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        byte by4 = this.readAndCheckByte();
        byte by5 = this.readAndCheckByte();
        byte by6 = this.readAndCheckByte();
        byte by7 = this.readAndCheckByte();
        byte by8 = this.readAndCheckByte();
        byte by9 = this.readAndCheckByte();
        return Longs.fromBytes(by9, by8, by7, by6, by5, by4, by3, by2);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    private byte readAndCheckByte() throws IOException, EOFException {
        int n2 = this.in.read();
        if (-1 == n2) {
            throw new EOFException();
        }
        return (byte)n2;
    }
}

