/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.util.concurrent;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Throwables;
import com.timevale.guava.common.util.concurrent.AbstractService;
import com.timevale.guava.common.util.concurrent.ListenableFuture;
import com.timevale.guava.common.util.concurrent.Service;
import java.util.concurrent.Executor;

@Beta
public abstract class AbstractExecutionThreadService
implements Service {
    private final Service delegate = new AbstractService(){

        @Override
        protected final void doStart() {
            AbstractExecutionThreadService.this.executor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractExecutionThreadService.this.startUp();
                        this.notifyStarted();
                        if (this.isRunning()) {
                            try {
                                AbstractExecutionThreadService.this.run();
                            }
                            catch (Throwable throwable) {
                                try {
                                    AbstractExecutionThreadService.this.shutDown();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        AbstractExecutionThreadService.this.shutDown();
                        this.notifyStopped();
                    }
                    catch (Throwable throwable) {
                        this.notifyFailed(throwable);
                        throw Throwables.propagate(throwable);
                    }
                }
            });
        }

        @Override
        protected void doStop() {
            AbstractExecutionThreadService.this.triggerShutdown();
        }
    };

    protected void startUp() throws Exception {
    }

    protected abstract void run() throws Exception;

    protected void shutDown() throws Exception {
    }

    protected void triggerShutdown() {
    }

    protected Executor executor() {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                new Thread(command, AbstractExecutionThreadService.this.getServiceName()).start();
            }
        };
    }

    public String toString() {
        return this.getServiceName() + " [" + (Object)((Object)this.state()) + "]";
    }

    @Override
    public final ListenableFuture<Service.State> start() {
        return this.delegate.start();
    }

    @Override
    public final Service.State startAndWait() {
        return this.delegate.startAndWait();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final ListenableFuture<Service.State> stop() {
        return this.delegate.stop();
    }

    @Override
    public final Service.State stopAndWait() {
        return this.delegate.stopAndWait();
    }

    protected String getServiceName() {
        return this.getClass().getSimpleName();
    }
}

