/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.jcajce;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.util.CollectionStore;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class JcaCertStore
extends CollectionStore {
    public JcaCertStore(Collection collection) throws CertificateEncodingException {
        super(JcaCertStore.convertCerts(collection));
    }

    private static Collection convertCerts(Collection collection) throws CertificateEncodingException {
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(collection.size());
        for (Object e2 : collection) {
            if (e2 instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)e2;
                try {
                    arrayList.add(new X509CertificateHolder(x509Certificate.getEncoded()));
                    continue;
                }
                catch (IOException iOException) {
                    throw new CertificateEncodingException("unable to read encoding: " + iOException.getMessage());
                }
            }
            arrayList.add((X509CertificateHolder)e2);
        }
        return arrayList;
    }
}

