/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSReadable;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedData;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableByteArray
implements CMSReadable,
CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final byte[] bytes;

    public CMSProcessableByteArray(byte[] byArray) {
        this(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), byArray);
    }

    public CMSProcessableByteArray(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this.type = aSN1ObjectIdentifier;
        this.bytes = byArray;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        outputStream.write(this.bytes);
    }

    @Override
    public Object getContent() {
        return Arrays.clone(this.bytes);
    }

    @Override
    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

