/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.Signer;
import com.timevale.tgtext.bouncycastle.crypto.digests.NullDigest;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.signers.DSADigestSigner;
import com.timevale.tgtext.bouncycastle.crypto.tls.AbstractTlsSigner;
import com.timevale.tgtext.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        if (signatureAndHashAlgorithm == null) {
            signer.update(byArray, 16, 20);
        } else {
            signer.update(byArray, 0, byArray.length);
        }
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, false, asymmetricKeyParameter);
        if (signatureAndHashAlgorithm == null) {
            signer.update(byArray2, 16, 20);
        } else {
            signer.update(byArray2, 0, byArray2.length);
        }
        return signer.verifySignature(byArray);
    }

    @Override
    public Signer createSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, true, asymmetricKeyParameter);
    }

    @Override
    public Signer createVerifyer(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, false, asymmetricKeyParameter);
    }

    protected CipherParameters makeInitParameters(boolean bl2, CipherParameters cipherParameters) {
        return cipherParameters;
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, boolean bl2, boolean bl3, CipherParameters cipherParameters) {
        if (signatureAndHashAlgorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short s2 = signatureAndHashAlgorithm == null ? (short)2 : (short)signatureAndHashAlgorithm.getHash();
        Digest digest = bl2 ? new NullDigest() : TlsUtils.createHash(s2);
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(s2), digest);
        dSADigestSigner.init(bl3, this.makeInitParameters(bl3, cipherParameters));
        return dSADigestSigner;
    }

    protected abstract short getSignatureAlgorithm();

    protected abstract DSA createDSAImpl(short var1);
}

