/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.signers.ECDSASigner;
import com.timevale.tgtext.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsDSASigner;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof ECPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short s2) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(s2)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 3;
    }
}

