/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.dvcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignedData;
import com.timevale.tgtext.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.dvcs.ServiceType;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.dvcs.CCPDRequestData;
import com.timevale.tgtext.bouncycastle.dvcs.CPDRequestData;
import com.timevale.tgtext.bouncycastle.dvcs.DVCSConstructionException;
import com.timevale.tgtext.bouncycastle.dvcs.DVCSMessage;
import com.timevale.tgtext.bouncycastle.dvcs.DVCSRequestData;
import com.timevale.tgtext.bouncycastle.dvcs.DVCSRequestInfo;
import com.timevale.tgtext.bouncycastle.dvcs.VPKCRequestData;
import com.timevale.tgtext.bouncycastle.dvcs.VSDRequestData;

public class DVCSRequest
extends DVCSMessage {
    private com.timevale.tgtext.bouncycastle.asn1.dvcs.DVCSRequest asn1;
    private DVCSRequestInfo reqInfo;
    private DVCSRequestData data;

    public DVCSRequest(CMSSignedData cMSSignedData) throws DVCSConstructionException {
        this(SignedData.getInstance(cMSSignedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSRequest(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSRequestData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.timevale.tgtext.bouncycastle.asn1.dvcs.DVCSRequest.getInstance(contentInfo.getContent()) : com.timevale.tgtext.bouncycastle.asn1.dvcs.DVCSRequest.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new DVCSConstructionException("Unable to parse content: " + exception.getMessage(), exception);
        }
        this.reqInfo = new DVCSRequestInfo(this.asn1.getRequestInformation());
        int n2 = this.reqInfo.getServiceType();
        if (n2 == ServiceType.CPD.getValue().intValue()) {
            this.data = new CPDRequestData(this.asn1.getData());
        } else if (n2 == ServiceType.VSD.getValue().intValue()) {
            this.data = new VSDRequestData(this.asn1.getData());
        } else if (n2 == ServiceType.VPKC.getValue().intValue()) {
            this.data = new VPKCRequestData(this.asn1.getData());
        } else if (n2 == ServiceType.CCPD.getValue().intValue()) {
            this.data = new CCPDRequestData(this.asn1.getData());
        } else {
            throw new DVCSConstructionException("Unknown service type: " + n2);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }

    public DVCSRequestInfo getRequestInfo() {
        return this.reqInfo;
    }

    public DVCSRequestData getData() {
        return this.data;
    }

    public GeneralName getTransactionIdentifier() {
        return this.asn1.getTransactionIdentifier();
    }
}

