/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.field;

import com.timevale.tgtext.bouncycastle.math.field.FiniteField;
import com.timevale.tgtext.bouncycastle.math.field.GF2Polynomial;
import com.timevale.tgtext.bouncycastle.math.field.GenericPolynomialExtensionField;
import com.timevale.tgtext.bouncycastle.math.field.PolynomialExtensionField;
import com.timevale.tgtext.bouncycastle.math.field.PrimeField;
import java.math.BigInteger;

public abstract class FiniteFields {
    static final FiniteField GF_2 = new PrimeField(BigInteger.valueOf(2L));
    static final FiniteField GF_3 = new PrimeField(BigInteger.valueOf(3L));

    public static PolynomialExtensionField getBinaryExtensionField(int[] nArray) {
        if (nArray[0] != 0) {
            throw new IllegalArgumentException("Irreducible polynomials in GF(2) must have constant term");
        }
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] > nArray[i2 - 1]) continue;
            throw new IllegalArgumentException("Polynomial exponents must be montonically increasing");
        }
        return new GenericPolynomialExtensionField(GF_2, new GF2Polynomial(nArray));
    }

    public static FiniteField getPrimeField(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        if (bigInteger.signum() <= 0 || n2 < 2) {
            throw new IllegalArgumentException("'characteristic' must be >= 2");
        }
        if (n2 < 3) {
            switch (bigInteger.intValue()) {
                case 2: {
                    return GF_2;
                }
                case 3: {
                    return GF_3;
                }
            }
        }
        return new PrimeField(bigInteger);
    }
}

