/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.xmss;

import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusPrivateKeyParameters {
    private final byte[][] privateKey;

    protected WOTSPlusPrivateKeyParameters(WOTSPlusParameters wOTSPlusParameters, byte[][] byArray) {
        if (wOTSPlusParameters == null) {
            throw new NullPointerException("params == null");
        }
        if (byArray == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (XMSSUtil.hasNullPointer(byArray)) {
            throw new NullPointerException("privateKey byte array == null");
        }
        if (byArray.length != wOTSPlusParameters.getLen()) {
            throw new IllegalArgumentException("wrong privateKey format");
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2].length == wOTSPlusParameters.getDigestSize()) continue;
            throw new IllegalArgumentException("wrong privateKey format");
        }
        this.privateKey = XMSSUtil.cloneArray(byArray);
    }

    protected byte[][] toByteArray() {
        return XMSSUtil.cloneArray(this.privateKey);
    }
}

