/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abx;
    protected Alignment aby = Alignment.LEFT;
    protected DrawInterface abz;
    protected char abA = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abx = position;
        this.abz = leader;
        this.aby = alignment;
        this.abA = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.DV(), tabStop.DX(), tabStop.DW(), tabStop.DY());
    }

    public float DV() {
        return this.abx;
    }

    public void an(float f2) {
        this.abx = f2;
    }

    public Alignment DW() {
        return this.aby;
    }

    public void a(Alignment alignment) {
        this.aby = alignment;
    }

    public DrawInterface DX() {
        return this.abz;
    }

    public void a(DrawInterface drawInterface) {
        this.abz = drawInterface;
    }

    public char DY() {
        return this.abA;
    }

    public void k(char c2) {
        this.abA = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abx;
        float f6 = f3 - f2;
        switch (this.aby) {
            case RIGHT: {
                if (f2 + f6 < this.abx) {
                    f5 = this.abx - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abx) {
                    f5 = this.abx - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abx) {
                        f5 = this.abx - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abx ? this.abx - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

