/*
 * Decompiled with CFR 0.152.
 */
package esign.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class JsonHelper {
    public static <T> T fromString(String json, Class<T> cls) {
        if (null == json) {
            return null;
        }
        return (T)new Gson().fromJson(json, cls);
    }

    public static <T> T fromString(GsonBuilder builder, String json, Class<T> cls) {
        if (null == json) {
            return null;
        }
        return (T)builder.create().fromJson(json, cls);
    }

    public static <T> T fromString(String json, Type type) {
        if (null == json) {
            return null;
        }
        return (T)new Gson().fromJson(json, type);
    }

    public static <T> T fromString(GsonBuilder builder, String json, Type type) {
        if (null == json) {
            return null;
        }
        return (T)builder.create().fromJson(json, type);
    }

    public static <T> List<T> fromString2List(GsonBuilder builder, String json, Type type) {
        if (null == json) {
            return null;
        }
        return (List)builder.create().fromJson(json, type);
    }

    public static <K, V> Map<K, V> fromString2Map(String json, Type type) {
        if (null == json) {
            return null;
        }
        return (Map)new Gson().fromJson(json, type);
    }

    public static <K, V> Map<K, V> fromString2Map(GsonBuilder builder, String json, Type type) {
        if (null == json) {
            return null;
        }
        return (Map)builder.create().fromJson(json, type);
    }

    public static <T> String toJson(T obj) {
        if (null == obj) {
            return "";
        }
        return new Gson().toJson(obj);
    }

    public static <T> String toJson(GsonBuilder builder, T obj) {
        if (null == obj) {
            return "";
        }
        return builder.create().toJson(obj);
    }

    public static <T> T fromJson(GsonBuilder builder, JsonObject json, Class<T> cls) {
        if (null == json) {
            return null;
        }
        return (T)builder.create().fromJson((JsonElement)json, cls);
    }

    public static <T> T fromJson(JsonObject json, Class<T> cls) {
        if (null == json) {
            return null;
        }
        return (T)new Gson().fromJson((JsonElement)json, cls);
    }

    public static <T> T fromJson(Map<?, ?> json, Class<T> cls) {
        if (null == json) {
            return null;
        }
        Gson gson = new Gson();
        return (T)gson.fromJson(gson.toJson(json), cls);
    }

    public static <T> T fromJsonAndDateFormat(Map<?, ?> json, Class<T> cls, String dateFormat) {
        if (null == json) {
            return null;
        }
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).create();
        return (T)gson.fromJson(gson.toJson(json), cls);
    }

    public static <T> JsonElement toGsonElement(T obj) {
        return new Gson().toJsonTree(obj);
    }

    public static <T> JsonElement toGsonElement(GsonBuilder builder, T obj) {
        return builder.create().toJsonTree(obj);
    }

    public static JsonElement fromString(String json) {
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parse(json);
    }

    public static <T> String sortEntityToString(T t2, Comparator<Map.Entry<String, JsonElement>> compare, IStreamalbe<String, JsonElement> streamable) {
        return JsonHelper.sortToString((JsonObject)JsonHelper.toGsonElement(t2), compare, streamable);
    }

    public static <K, V> String sortToString(Map<K, V> map, Comparator<Map.Entry<K, V>> compare, IStreamalbe<K, V> streamable) {
        Set<Map.Entry<K, V>> set = JsonHelper.sort(map, compare);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<K, V>> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(streamable.stream(iterator.next()));
        }
        return stringBuilder.toString();
    }

    public static String sortToString(JsonObject json, Comparator<Map.Entry<String, JsonElement>> compare, IStreamalbe<String, JsonElement> streamable) {
        Set<Map.Entry<String, JsonElement>> set = JsonHelper.sort(json, compare);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, JsonElement>> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(streamable.stream(iterator.next()));
        }
        return stringBuilder.toString();
    }

    public static <T> Set<Map.Entry<String, JsonElement>> sortEntity(T t2, Comparator<Map.Entry<String, JsonElement>> compare) {
        return JsonHelper.sort((JsonObject)JsonHelper.toGsonElement(t2), compare);
    }

    public static <K, V> Set<Map.Entry<K, V>> sort(Map<K, V> map, Comparator<Map.Entry<K, V>> compare) {
        TreeSet<Map.Entry<K, V>> treeSet = new TreeSet<Map.Entry<K, V>>(compare);
        treeSet.addAll(map.entrySet());
        return treeSet;
    }

    public static Set<Map.Entry<String, JsonElement>> sort(JsonObject json, Comparator<Map.Entry<String, JsonElement>> compare) {
        if (null == compare) {
            compare = DefaultJsonComparator.INSTANCE;
        }
        TreeSet<Map.Entry<String, JsonElement>> treeSet = new TreeSet<Map.Entry<String, JsonElement>>(compare);
        treeSet.addAll(json.entrySet());
        return treeSet;
    }

    private static enum DefaultJsonComparator implements Comparator<Map.Entry<String, JsonElement>>
    {
        INSTANCE;


        @Override
        public int compare(Map.Entry<String, JsonElement> o1, Map.Entry<String, JsonElement> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    public static interface IStreamalbe<K, V> {
        public String stream(Map.Entry<K, V> var1);
    }
}

