/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.configuration;

import esign.utils.configuration.Version;
import java.security.AccessControlException;
import java.util.Properties;

public class Configuration {
    private static Properties defaultProperty;
    private static boolean DALVIK;

    static void init() {
        defaultProperty = new Properties();
        defaultProperty.setProperty("esign.debug", "true");
        defaultProperty.setProperty("esign.clientURL", "http://open.t.sina.com.cn/-{esign.clientVersion}.xml");
        defaultProperty.setProperty("esign.http.userAgent", "esign http://open.t.sina.com.cn/ /{esign.clientVersion}");
        defaultProperty.setProperty("esign.http.useSSL", "false");
        defaultProperty.setProperty("esign.http.proxyHost.fallback", "http.proxyHost");
        defaultProperty.setProperty("esign.http.proxyPort.fallback", "http.proxyPort");
        defaultProperty.setProperty("esign.http.connectionTimeout", "20000");
        defaultProperty.setProperty("esign.http.readTimeout", "120000");
        defaultProperty.setProperty("esign.http.retryCount", "3");
        defaultProperty.setProperty("esign.http.retryIntervalSecs", "10");
        defaultProperty.setProperty("esign.async.numThreads", "1");
        defaultProperty.setProperty("esign.clientVersion", Version.getVersion());
        try {
            Class.forName("dalvik.system.VMRuntime");
            defaultProperty.setProperty("esign.dalvik", "true");
        }
        catch (ClassNotFoundException classNotFoundException) {
            defaultProperty.setProperty("esign.dalvik", "false");
        }
        DALVIK = Configuration.getBoolean("esign.dalvik");
    }

    public static boolean isDalvik() {
        return DALVIK;
    }

    public static boolean useSSL() {
        return Configuration.getBoolean("esign.http.useSSL");
    }

    public static String getScheme() {
        return Configuration.useSSL() ? "https://" : "http://";
    }

    public static String getCilentVersion() {
        return Configuration.getProperty("esign.clientVersion");
    }

    public static String getCilentVersion(String clientVersion) {
        return Configuration.getProperty("esign.clientVersion", clientVersion);
    }

    public static String getSource() {
        return Configuration.getProperty("esign.source");
    }

    public static String getSource(String source) {
        return Configuration.getProperty("esign.source", source);
    }

    public static String getProxyHost() {
        return Configuration.getProperty("esign.http.proxyHost");
    }

    public static String getProxyHost(String proxyHost) {
        return Configuration.getProperty("esign.http.proxyHost", proxyHost);
    }

    public static String getProxyUser() {
        return Configuration.getProperty("esign.http.proxyUser");
    }

    public static String getProxyUser(String user) {
        return Configuration.getProperty("esign.http.proxyUser", user);
    }

    public static String getClientURL() {
        return Configuration.getProperty("esign.clientURL");
    }

    public static String getClientURL(String clientURL) {
        return Configuration.getProperty("esign.clientURL", clientURL);
    }

    public static String getProxyPassword() {
        return Configuration.getProperty("esign.http.proxyPassword");
    }

    public static String getProxyPassword(String password) {
        return Configuration.getProperty("esign.http.proxyPassword", password);
    }

    public static int getProxyPort() {
        return Configuration.getIntProperty("esign.http.proxyPort");
    }

    public static int getProxyPort(int port) {
        return Configuration.getIntProperty("esign.http.proxyPort", port);
    }

    public static int getConnectionTimeout() {
        return Configuration.getIntProperty("esign.http.connectionTimeout");
    }

    public static int getConnectionTimeout(int connectionTimeout) {
        return Configuration.getIntProperty("esign.http.connectionTimeout", connectionTimeout);
    }

    public static int getReadTimeout() {
        return Configuration.getIntProperty("esign.http.readTimeout");
    }

    public static int getReadTimeout(int readTimeout) {
        return Configuration.getIntProperty("esign.http.readTimeout", readTimeout);
    }

    public static int getRetryCount() {
        return Configuration.getIntProperty("esign.http.retryCount");
    }

    public static int getRetryCount(int retryCount) {
        return Configuration.getIntProperty("esign.http.retryCount", retryCount);
    }

    public static int getRetryIntervalSecs() {
        return Configuration.getIntProperty("esign.http.retryIntervalSecs");
    }

    public static int getRetryIntervalSecs(int retryIntervalSecs) {
        return Configuration.getIntProperty("esign.http.retryIntervalSecs", retryIntervalSecs);
    }

    public static String getUser() {
        return Configuration.getProperty("esign.user");
    }

    public static String getUser(String userId) {
        return Configuration.getProperty("esign.user", userId);
    }

    public static String getPassword() {
        return Configuration.getProperty("esign.password");
    }

    public static String getPassword(String password) {
        return Configuration.getProperty("esign.password", password);
    }

    public static String getUserAgent() {
        return Configuration.getProperty("esign.http.userAgent");
    }

    public static String getUserAgent(String userAgent) {
        return Configuration.getProperty("esign.http.userAgent", userAgent);
    }

    public static String getOAuthConsumerKey() {
        return Configuration.getProperty("esign.oauth.consumerKey");
    }

    public static String getOAuthConsumerKey(String consumerKey) {
        return Configuration.getProperty("esign.oauth.consumerKey", consumerKey);
    }

    public static String getOAuthConsumerSecret() {
        return Configuration.getProperty("esign.oauth.consumerSecret");
    }

    public static String getOAuthConsumerSecret(String consumerSecret) {
        return Configuration.getProperty("esign.oauth.consumerSecret", consumerSecret);
    }

    public static boolean getBoolean(String name) {
        String string = Configuration.getProperty(name);
        return Boolean.valueOf(string);
    }

    public static int getIntProperty(String name) {
        String string = Configuration.getProperty(name);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getIntProperty(String name, int fallbackValue) {
        String string = Configuration.getProperty(name, String.valueOf(fallbackValue));
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static long getLongProperty(String name) {
        String string = Configuration.getProperty(name);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static String getProperty(String name) {
        return Configuration.getProperty(name, null);
    }

    public static String getProperty(String name, String fallbackValue) {
        String string;
        try {
            String string2;
            string = System.getProperty(name, fallbackValue);
            if (null == string) {
                string = defaultProperty.getProperty(name);
            }
            if (null == string && null != (string2 = defaultProperty.getProperty(name + ".fallback"))) {
                string = System.getProperty(string2);
            }
        }
        catch (AccessControlException accessControlException) {
            string = fallbackValue;
        }
        return Configuration.replace(string);
    }

    private static String replace(String value) {
        String string;
        int n2;
        if (null == value) {
            return value;
        }
        String string2 = value;
        int n3 = 0;
        if (-1 != (n3 = value.indexOf("{", n3)) && (n2 = value.indexOf("}", n3)) > n3 + 1 && (string = value.substring(n3 + 1, n2)).length() > 0) {
            string2 = value.substring(0, n3) + Configuration.getProperty(string) + value.substring(n2 + 1);
        }
        if (string2.equals(value)) {
            return value;
        }
        return Configuration.replace(string2);
    }

    public static int getNumberOfAsyncThreads() {
        return Configuration.getIntProperty("esign.async.numThreads");
    }

    public static boolean getDebug() {
        return Configuration.getBoolean("esign.debug");
    }

    static {
        Configuration.init();
    }
}

