/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.http;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class PostParameter
implements Serializable {
    String name;
    String value;
    private File file = null;
    private static final long serialVersionUID = -8708108746980739212L;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public PostParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public PostParameter(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public PostParameter(String name, int value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public PostParameter(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isFile() {
        return null != this.file;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String string = this.file.getName();
        int n2 = string.lastIndexOf(".");
        String string2 = -1 == n2 ? OCTET : ((string = string.substring(string.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(string) ? GIF : ("png".equals(string) ? PNG : ("jpg".equals(string) ? JPEG : OCTET))) : (string.length() == 4 ? ("jpeg".equals(string) ? JPEG : OCTET) : OCTET));
        return string2;
    }

    public static boolean containsFile(PostParameter[] params) {
        boolean bl2 = false;
        if (null == params) {
            return false;
        }
        for (PostParameter postParameter : params) {
            if (!postParameter.isFile()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    static boolean containsFile(List<PostParameter> params) {
        boolean bl2 = false;
        for (PostParameter postParameter : params) {
            if (!postParameter.isFile()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static PostParameter[] getParameterArray(String name, String value) {
        return new PostParameter[]{new PostParameter(name, value)};
    }

    public static PostParameter[] getParameterArray(String name, int value) {
        return PostParameter.getParameterArray(name, String.valueOf(value));
    }

    public static PostParameter[] getParameterArray(String name1, String value1, String name2, String value2) {
        return new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)};
    }

    public static PostParameter[] getParameterArray(String name1, int value1, String name2, int value2) {
        return PostParameter.getParameterArray(name1, String.valueOf(value1), name2, String.valueOf(value2));
    }

    public int hashCode() {
        int n2 = this.name.hashCode();
        n2 = 31 * n2 + this.value.hashCode();
        n2 = 31 * n2 + (this.file != null ? this.file.hashCode() : 0);
        return n2;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof PostParameter) {
            PostParameter postParameter = (PostParameter)obj;
            if (this.file != null ? !this.file.equals(postParameter.file) : postParameter.file != null) {
                return false;
            }
            return this.name.equals(postParameter.name) && this.value.equals(postParameter.value);
        }
        return false;
    }

    public String toString() {
        return "PostParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", file=" + this.file + '}';
    }

    public int compareTo(Object o2) {
        PostParameter postParameter = (PostParameter)o2;
        int n2 = this.name.compareTo(postParameter.name);
        if (0 == n2) {
            n2 = this.value.compareTo(postParameter.value);
        }
        return n2;
    }

    public static String encodeParameters(PostParameter[] httpParams) {
        if (null == httpParams) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < httpParams.length; ++i2) {
            if (httpParams[i2].isFile()) {
                throw new IllegalArgumentException("parameter [" + httpParams[i2].name + "]should be text");
            }
            if (i2 != 0) {
                stringBuffer.append("&");
            }
            try {
                stringBuffer.append(URLEncoder.encode(httpParams[i2].name, "UTF-8")).append("=").append(URLEncoder.encode(httpParams[i2].value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

