/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.httpclient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import esign.utils.IOUtil;
import esign.utils.StringUtil;
import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.http.HttpExtend;
import esign.utils.httpclient.HttpConfig;
import esign.utils.httpclient.HttpConfigT;
import esign.utils.httpclient.HttpDeleteBody;
import esign.utils.httpclient.IResponseParser;
import esign.utils.httpclient.Method;
import esign.utils.httppool.HttpPool;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static HttpPool defaultGlobalPool = new HttpPool(10, 2);
    private static final String DEFAULT_ENCODE = "UTF-8";
    private static final IResponseParser<JsonElement> DEFAULT = new IResponseParser<JsonElement>(){

        @Override
        public JsonElement parse(byte[] data, String charset) throws SuperException {
            String string = HttpUtil.stringify(data, charset);
            try {
                JsonParser jsonParser = new JsonParser();
                return jsonParser.parse(string);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                LOGGER.error("invalid json. string:{}", (Object)string);
                LOGGER.error("exception:", (Throwable)jsonSyntaxException);
                throw ErrorsDiscriptor.InvalidFormat.e(jsonSyntaxException);
            }
        }
    };

    public static synchronized void initDefaultGlobalConnectionPool(HttpPool pool) {
        AssertSupport.checkPoint(!defaultGlobalPool.hasInitialized(), "global connection pool in http util has initialized yet.", new Object[0]);
        HttpPool httpPool = defaultGlobalPool;
        defaultGlobalPool = pool;
        httpPool.destroy();
    }

    private static synchronized HttpPool getConnectionPool(HttpConfig config) {
        if (null != config.getHttpPool()) {
            return config.getHttpPool();
        }
        return defaultGlobalPool;
    }

    public static JsonObject postSubmit(Method meth, String url, JsonObject content) throws SuperException {
        return HttpUtil.postSubmit(meth, url, content, new HttpConfig());
    }

    public static String streamPostSubmit(Method meth, String url, JsonObject content) throws SuperException {
        return HttpUtil.streamPostSubmit(meth, url, content, new HttpConfig());
    }

    public static JsonObject postSubmit(Method meth, String url, JsonObject content, List<HttpExtend> extend) throws SuperException {
        return HttpUtil.postSubmit(meth, url, content, extend, new HttpConfig());
    }

    public static JsonObject postBody(Method meth, String url, JsonObject content) throws SuperException {
        return HttpUtil.postBody(meth, url, content, new HttpConfig());
    }

    public static JsonElement postBodyNull(Method meth, String url, String content, HttpConfig config) throws SuperException {
        return HttpUtil.postBodyNull(meth, url, content, HttpUtil.defaultHttpConfigT(config));
    }

    public static JsonObject getBody(Method meth, String url) throws SuperException {
        return HttpUtil.getBody(meth, url, new HttpConfig());
    }

    public static JsonObject postSubmit(Method meth, String url, JsonObject content, HttpConfig config) throws SuperException {
        UrlEncodedFormEntity urlEncodedFormEntity;
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(meth, url, config);
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(HttpUtil.convertToParams(content), config.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorsDiscriptor.InternalService.e(unsupportedEncodingException);
        }
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)urlEncodedFormEntity);
        return (JsonObject)HttpUtil.run(httpEntityEnclosingRequestBase, HttpUtil.defaultHttpConfigT(config));
    }

    public static String streamPostSubmit(Method meth, String url, JsonObject content, HttpConfig config) throws SuperException {
        UrlEncodedFormEntity urlEncodedFormEntity;
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(meth, url, config);
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(HttpUtil.convertToParams(content), config.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorsDiscriptor.InternalService.e(unsupportedEncodingException);
        }
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)urlEncodedFormEntity);
        return HttpUtil.stringify(HttpUtil.rawRun((HttpUriRequest)httpEntityEnclosingRequestBase, config));
    }

    public static String download(String url, HttpConfig config) throws SuperException {
        return HttpUtil.getAsString(url, config);
    }

    public static byte[] get(String url, HttpConfig config) throws SuperException {
        HttpGet httpGet = HttpUtil.getGetMethod(Method.Get, url, config);
        return HttpUtil.rawRun((HttpUriRequest)httpGet, config);
    }

    public static String getAsString(String url, HttpConfig config, String charset) throws SuperException {
        HttpGet httpGet = HttpUtil.getGetMethod(Method.Get, url, config);
        return HttpUtil.stringify(HttpUtil.rawRun((HttpUriRequest)httpGet, config), charset);
    }

    public static String getAsString(String url, HttpConfig config) throws SuperException {
        return HttpUtil.getAsString(url, config, DEFAULT_ENCODE);
    }

    public static JsonObject postSubmit(Method meth, String url, JsonObject content, List<HttpExtend> extend, HttpConfig config) throws SuperException {
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(meth, url, config);
        HttpEntity httpEntity = HttpUtil.convertToParams(content, extend);
        httpEntityEnclosingRequestBase.setEntity(httpEntity);
        return (JsonObject)HttpUtil.run(httpEntityEnclosingRequestBase, HttpUtil.defaultHttpConfigT(config));
    }

    public static JsonObject postBody(Method meth, String url, JsonObject content, HttpConfig config) throws SuperException {
        return (JsonObject)HttpUtil.postBody(meth, url, content, HttpUtil.defaultHttpConfigT(config));
    }

    public static <T> T postBodyNull(Method meth, String url, String content, HttpConfigT<T> config) throws SuperException {
        ByteArrayEntity byteArrayEntity;
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(meth, url, config);
        try {
            byteArrayEntity = new ByteArrayEntity(content.toString().getBytes(config.getEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("unsupport encoding.", (Throwable)unsupportedEncodingException);
            throw ErrorsDiscriptor.UnsupportCharset.e(unsupportedEncodingException, config.getEncoding());
        }
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)byteArrayEntity);
        return HttpUtil.run(httpEntityEnclosingRequestBase, config);
    }

    public static <T> T postBody(Method meth, String url, JsonObject content, HttpConfigT<T> config) throws SuperException {
        ByteArrayEntity byteArrayEntity;
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(meth, url, config);
        try {
            byteArrayEntity = new ByteArrayEntity(content.toString().getBytes(config.getEncoding()), ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)config.getEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("unsupport encoding.", (Throwable)unsupportedEncodingException);
            throw ErrorsDiscriptor.UnsupportCharset.e(unsupportedEncodingException, config.getEncoding());
        }
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)byteArrayEntity);
        return HttpUtil.run(httpEntityEnclosingRequestBase, config);
    }

    public static <T> T upload(String url, InputStream inputStream, HttpConfigT<T> config) throws SuperException {
        try {
            return HttpUtil.upload(url, IOUtil.readStreamAsByteArray(inputStream), config);
        }
        catch (IOException iOException) {
            LOGGER.error("read stream failed.", (Throwable)iOException);
            throw ErrorsDiscriptor.FileStream.e(iOException);
        }
    }

    public static <T, I extends Serializable> T upload(String url, I data, HttpConfigT<T> config) throws SuperException {
        try {
            return HttpUtil.upload(url, data.toString().getBytes(config.getEncoding()), config);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("unsupport charset. charset:{}", (Object)config.getEncoding());
            LOGGER.error("exception:", (Throwable)unsupportedEncodingException);
            throw ErrorsDiscriptor.UnsupportCharset.e(config.getEncoding());
        }
    }

    public static <T> T upload(String url, byte[] data, HttpConfigT<T> config) throws SuperException {
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(Method.Put, url, config);
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(data, ContentType.APPLICATION_OCTET_STREAM);
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)byteArrayEntity);
        return HttpUtil.run(httpEntityEnclosingRequestBase, config);
    }

    @Deprecated
    public static JsonObject sendPostBody(Method meth, String url, String urlParam) throws SuperException {
        return HttpUtil.sendPostBody(meth, url, urlParam, new HttpConfig());
    }

    public static JsonObject getBody(Method meth, String url, HttpConfig config) throws SuperException {
        HttpGet httpGet = HttpUtil.getGetMethod(meth, url, config);
        return (JsonObject)HttpUtil.run((HttpUriRequest)httpGet, HttpUtil.defaultHttpConfigT(config));
    }

    private static <T> T run(HttpEntityEnclosingRequestBase req, HttpConfigT<T> config) throws SuperException {
        if (null != config.getRequestReady()) {
            config.getRequestReady().ready((HttpMessage)req, req.getEntity());
        }
        return HttpUtil.run((HttpUriRequest)req, config);
    }

    private static <T> T run(HttpUriRequest req, HttpConfigT<T> config) throws SuperException {
        byte[] byArray = HttpUtil.rawRun(req, config);
        return config.parse(byArray, config.getEncoding());
    }

    private static HttpConfigT<JsonElement> defaultHttpConfigT(HttpConfig config) {
        return new HttpConfigT<JsonElement>(JsonElement.class, DEFAULT, config);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] rawRun(HttpUriRequest req, HttpConfig config) throws SuperException {
        byte[] byArray;
        CloseableHttpClient closeableHttpClient = null;
        InputStream inputStream = null;
        try {
            closeableHttpClient = HttpUtil.getConnectionPool(config).client(config);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(req);
            inputStream = HttpUtil.getNetworkStream((HttpResponse)closeableHttpResponse);
            HttpUtil.checkResponse((HttpResponse)closeableHttpResponse);
            byte[] byArray2 = HttpUtil.response(inputStream);
            if (null != config.getResponseReady()) {
                config.getResponseReady().ready((HttpResponse)closeableHttpResponse, byArray2);
            }
            byArray = byArray2;
        }
        catch (SuperException superException) {
            try {
                LOGGER.error("http to url failed. url:{}", (Object)req.getURI().toString());
                LOGGER.error("http client execute failed.", (Throwable)superException);
                throw superException;
                catch (Exception exception) {
                    LOGGER.error("http to url failed. url:{}", (Object)req.getURI().toString());
                    LOGGER.error("http client execute failed.", (Throwable)exception);
                    throw ErrorsDiscriptor.ExternalService.e(exception);
                }
            }
            catch (Throwable throwable) {
                HttpUtil.close(closeableHttpClient, inputStream);
                throw throwable;
            }
        }
        HttpUtil.close(closeableHttpClient, inputStream);
        return byArray;
    }

    private static void close(CloseableHttpClient cli, InputStream stm) throws SuperException {
        if (null != stm) {
            try {
                stm.close();
                return;
            }
            catch (IOException iOException) {
                LOGGER.error("stream close failed and then close the connection.", (Throwable)iOException);
            }
        }
    }

    private static byte[] response(InputStream stream) throws SuperException {
        try {
            return IOUtil.readStreamAsByteArray(stream);
        }
        catch (IOException iOException) {
            LOGGER.error("read data from response stream failed.", (Throwable)iOException);
            throw ErrorsDiscriptor.ExternalService.e(iOException);
        }
    }

    private static void checkResponse(HttpResponse resp) throws SuperException {
        int n2 = resp.getStatusLine().getStatusCode();
        if (n2 >= 200 && n2 < 300) {
            return;
        }
        LOGGER.error("http execute failed. code:{}", (Object)n2);
        throw ErrorsDiscriptor.ExternalServiceNetwork.e(n2);
    }

    private static InputStream getNetworkStream(HttpResponse resp) throws SuperException {
        try {
            if (null == resp.getEntity()) {
                LOGGER.error("there is no json data in body.");
                throw ErrorsDiscriptor.ExternalService.e();
            }
            return resp.getEntity().getContent();
        }
        catch (Exception exception) {
            LOGGER.error("http execute failed.", (Throwable)exception);
            throw ErrorsDiscriptor.ExternalService.e(exception);
        }
    }

    private static HttpEntityEnclosingRequestBase getMethod(Method method, String url, HttpConfig conf) {
        Object object = null;
        switch (method) {
            case Post: {
                object = new HttpPost(url);
                break;
            }
            case Put: {
                object = new HttpPut(url);
                break;
            }
            case Delete: {
                object = new HttpDeleteBody(url);
                break;
            }
            default: {
                LOGGER.error("invalid method. type:{}", (Object)method);
                object = new HttpPost();
            }
        }
        if (null == conf.getHeaderMgmt()) {
            return object;
        }
        conf.getHeaderMgmt().installHeaders((HttpMessage)object);
        return object;
    }

    private static HttpGet getGetMethod(Method method, String url, HttpConfig conf) {
        HttpGet httpGet = null;
        switch (method) {
            case Get: {
                httpGet = new HttpGet(url);
                break;
            }
            default: {
                LOGGER.error("invalid method. type:{}", (Object)method);
                httpGet = new HttpGet();
            }
        }
        if (null == conf.getHeaderMgmt()) {
            return httpGet;
        }
        conf.getHeaderMgmt().installHeaders((HttpMessage)httpGet);
        return httpGet;
    }

    private static List<NameValuePair> convertToParams(JsonObject input) {
        Set set = input.entrySet();
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        for (Map.Entry entry : set) {
            arrayList.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
        }
        return arrayList;
    }

    private static HttpEntity convertToParams(JsonObject input, List<HttpExtend> extend) {
        StringBody stringBody;
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        Set set = input.entrySet();
        for (Map.Entry object : set) {
            stringBody = new StringBody(((JsonElement)object.getValue()).getAsString(), ContentType.TEXT_PLAIN.withCharset(Charset.forName(DEFAULT_ENCODE)));
            multipartEntityBuilder.addPart((String)object.getKey(), (ContentBody)stringBody);
        }
        for (HttpExtend httpExtend : extend) {
            stringBody = null;
            switch (httpExtend.getType()) {
                case FILE: {
                    stringBody = new FileBody(new File((String)httpExtend.getValue()));
                    break;
                }
                case FILE_STREAM: {
                    stringBody = new ByteArrayBody((byte[])httpExtend.getValue(), ContentType.APPLICATION_OCTET_STREAM, "");
                    break;
                }
            }
            multipartEntityBuilder.addPart(httpExtend.getName(), (ContentBody)stringBody);
        }
        return multipartEntityBuilder.build();
    }

    @Deprecated
    public static String PostResponse(String url, String param) throws IOException {
        String string = null;
        URL uRL = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        ((OutputStream)dataOutputStream).write(param.getBytes());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), DEFAULT_ENCODE));
        }
        catch (IOException iOException) {
            LOGGER.error("PostResponse failed.", (Throwable)iOException);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        bufferedReader.close();
        if (null != stringBuffer) {
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String putResponse(String url, String param) throws IOException {
        return HttpUtil.putResponse(url, param, null);
    }

    @Deprecated
    public static String putResponse(String url, String param, String contentType) throws IOException {
        Closeable closeable;
        String string = null;
        URL uRL = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("PUT");
        if (!StringUtil.isNull(contentType)) {
            httpURLConnection.setRequestProperty("Content-Type", contentType);
        }
        if (!StringUtil.isNull(param)) {
            closeable = new DataOutputStream(httpURLConnection.getOutputStream());
            ((OutputStream)closeable).write(param.getBytes());
        }
        closeable = null;
        int n2 = httpURLConnection.getResponseCode();
        if (200 == n2) {
            try {
                closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), DEFAULT_ENCODE));
            }
            catch (IOException iOException) {
                LOGGER.error("putResponse failed.", (Throwable)iOException);
                return null;
            }
        } else {
            closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), DEFAULT_ENCODE));
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        while ((string2 = ((BufferedReader)closeable).readLine()) != null) {
            stringBuffer.append(string2);
        }
        ((BufferedReader)closeable).close();
        if (null != stringBuffer) {
            string = stringBuffer.toString();
        }
        return string;
    }

    @Deprecated
    public static JsonObject sendPostBody(Method method, String url, String urlParam, HttpConfig config) throws SuperException {
        ByteArrayEntity byteArrayEntity;
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = HttpUtil.getMethod(method, url, config);
        try {
            byteArrayEntity = new ByteArrayEntity(urlParam.getBytes(config.getEncoding()), ContentType.create((String)ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), (String)config.getEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("unsupport encoding.", (Throwable)unsupportedEncodingException);
            throw ErrorsDiscriptor.InternalService.e(unsupportedEncodingException);
        }
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)byteArrayEntity);
        return (JsonObject)HttpUtil.run(httpEntityEnclosingRequestBase, HttpUtil.defaultHttpConfigT(config));
    }

    private static String stringify(byte[] data) throws SuperException {
        return HttpUtil.stringify(data, DEFAULT_ENCODE);
    }

    private static String stringify(byte[] data, String charset) throws SuperException {
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("unsupported encoding. encoding:{}", (Object)charset);
            LOGGER.error("exception:", (Throwable)unsupportedEncodingException);
            throw ErrorsDiscriptor.UnsupportCharset.e(unsupportedEncodingException, charset);
        }
    }
}

