/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.provider;

import esign.utils.Base64;
import esign.utils.enumadp.EnumAdapter;
import esign.utils.enumadp.IEnumAdapter;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.security.RSAKeyUtil;
import esign.utils.security.model.AsymmetricAlgorithmModel;
import esign.utils.security.model.DigestAlgorithmModel;
import esign.utils.security.provider.impl.SignDigestAdapter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SignerProivder implements IEnumAdapter<AsymmetricAlgorithmModel, SignerProivder>
{
    RSA(AsymmetricAlgorithmModel.RSA, "RSA"),
    DSA(AsymmetricAlgorithmModel.DSA, "DSA");

    private String signAlg;
    private AsymmetricAlgorithmModel signType;
    private static final EnumAdapter<SignerProivder, AsymmetricAlgorithmModel, SignerProivder> adapter;
    private static final Logger LOGGER;

    private SignerProivder(AsymmetricAlgorithmModel signType, String signAlg) {
        this.signType = signType;
        this.signAlg = signAlg;
    }

    public static SignerProivder from(AsymmetricAlgorithmModel model) {
        return adapter.get(model);
    }

    public Signature signer(DigestAlgorithmModel digest, String pkcs8Key) throws SuperException {
        return this.signer(digest, Base64.decode(pkcs8Key));
    }

    public Signature signer(DigestAlgorithmModel digest, byte[] pkcs8Key) throws SuperException {
        return this.createSignature(digest, pkcs8Key, new InitPrivateKey());
    }

    public Signature verifier(DigestAlgorithmModel digest, byte[] x509Key) throws SuperException {
        return this.createSignature(digest, x509Key, new InitPublicKey());
    }

    private Signature createSignature(DigestAlgorithmModel digest, byte[] key, InitKey initKey) throws SuperException {
        Signature signature;
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance(this.signAlg);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.error("no such alg. alg:{}", (Object)this.signAlg);
            LOGGER.error("exception:", (Throwable)noSuchAlgorithmException);
            throw ErrorsDiscriptor.InvalidCipherAlgorithm.e(noSuchAlgorithmException);
        }
        String string = SignDigestAdapter.from(digest).generateSignDigestAlgDiscription(this.signAlg);
        try {
            signature = Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.error("no such alg. alg:{}", (Object)string);
            LOGGER.error("exception:", (Throwable)noSuchAlgorithmException);
            throw ErrorsDiscriptor.InvalidCipherAlgorithm.e(noSuchAlgorithmException);
        }
        initKey.init(keyFactory, signature, key);
        return signature;
    }

    @Override
    public AsymmetricAlgorithmModel getFrom() {
        return this.signType;
    }

    @Override
    public SignerProivder getTo() {
        return this;
    }

    static {
        adapter = new EnumAdapter(SignerProivder.class);
        LOGGER = LoggerFactory.getLogger(SignerProivder.class);
    }

    private static interface InitKey {
        public void init(KeyFactory var1, Signature var2, byte[] var3) throws SuperException;
    }

    private class InitPrivateKey
    implements InitKey {
        private InitPrivateKey() {
        }

        @Override
        public void init(KeyFactory keyFactory, Signature signature, byte[] key) throws SuperException {
            try {
                PrivateKey privateKey = RSAKeyUtil.parsePrivateKey(keyFactory, key);
                signature.initSign(privateKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                LOGGER.error("invalid key.", (Throwable)invalidKeyException);
                throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeyException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                LOGGER.error("invalid key.", (Throwable)invalidKeySpecException);
                throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeySpecException);
            }
        }
    }

    private class InitPublicKey
    implements InitKey {
        private InitPublicKey() {
        }

        @Override
        public void init(KeyFactory keyFactory, Signature signature, byte[] key) throws SuperException {
            try {
                PublicKey publicKey = RSAKeyUtil.parsePublieKey(keyFactory, key);
                signature.initVerify(publicKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                LOGGER.error("invalid key.", (Throwable)invalidKeyException);
                throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeyException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                LOGGER.error("invalid key.", (Throwable)invalidKeySpecException);
                throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeySpecException);
            }
        }
    }
}

