/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.sign.a;

import com.timevale.esign.paas.tech.bean.bean.MultiSignatureInfo;
import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.bean.SignPDFDocBean;
import com.timevale.esign.paas.tech.bean.result.AccountInfoResult;
import com.timevale.esign.paas.tech.bean.result.CreateSignDetailResult;
import com.timevale.esign.paas.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.common.Precondition;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.SignType;
import com.timevale.esign.paas.tech.service.AccountService;
import com.timevale.esign.paas.tech.sign.IPdfSigner;
import com.timevale.esign.paas.tech.sign.b;
import com.timevale.esign.paas.tech.util.DigestUtil;
import com.timevale.esign.paas.tech.util.FileRWUtil;
import com.timevale.esign.paas.tech.util.RequestUtil;
import com.timevale.esign.paas.tech.util.TimeFormatUtil;
import com.timevale.tech.sdk.utils.ImageUtil;
import com.timevale.tgpdfsign.b.g;
import com.timevale.tgpdfsign.enums.DescriptionType;
import com.timevale.tgpdfsign.enums.EdgePosXAdjustType;
import com.timevale.tgpdfsign.sign.e;
import com.timevale.tgpdfsign.sign.h;
import esign.utils.StringUtil;
import esign.utils.asserts.AssertSupport;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class a
implements IPdfSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(a.class);
    protected static final float Jn = 159.0f;
    protected static final String Jo = "png";
    private static final String Jp = "Unknown system error: unknown seal type";
    protected static final int Jq = 6000;
    private static final String Jr = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWNgYGBgAAAABQABh6FO1AAAAABJRU5ErkJggg==";
    private AbstractServiceClient Jg;
    protected SignPDFDocBean Js;
    protected MultiSignatureInfo Jt;
    protected com.timevale.esign.paas.tech.sign.b.a Ju;
    private CreateSignDetailResult Jv;
    private String Jw;

    a(AbstractServiceClient abstractServiceClient, SignPDFDocBean signPDFDocBean, List<PosBean> list, SignType signType, String string, com.timevale.esign.paas.tech.sign.b.a a2) {
        this.Jg = abstractServiceClient;
        this.Js = signPDFDocBean;
        this.Ju = a2;
        this.Jt = new MultiSignatureInfo(list, signType, string);
    }

    public AbstractServiceClient uy() {
        return this.Jg;
    }

    public String getSealData() {
        return StringUtils.isEmpty((String)this.Jt.getSealData()) ? Jr : this.Jt.getSealData();
    }

    public void setSealData(String sealData) {
        this.Jt.setSealData(sealData);
    }

    public List<PosBean> getSignPos() {
        return this.Jt.getSignPos();
    }

    void setSignPos(List<PosBean> signPos) {
        this.Jt.setSignPos(signPos);
    }

    void setSignType(SignType signType) {
        this.Jt.setSignType(signType);
    }

    String uF() {
        if (StringUtil.isNull(this.Jw)) {
            this.Jw = "".concat(this.Jv.getViewSignDetailUrl()).concat("?id=").concat(this.Jv.getSignServiceId());
            if (this.Ju instanceof com.timevale.esign.paas.tech.sign.b.b && this.Jv.isNeedWillId()) {
                this.Jw = this.Jw + "&willAuthId=" + ((com.timevale.esign.paas.tech.sign.b.b)this.Ju).uP();
            }
        }
        return this.Jw;
    }

    CreateSignDetailResult uG() {
        return this.Jv;
    }

    protected float a(PosBean posBean) throws SuperException {
        return posBean.getWidth();
    }

    protected float b(PosBean posBean) throws SuperException {
        return posBean.getHeight();
    }

    protected abstract void cS(String var1) throws SuperException;

    protected abstract void a(SignPDFDocBean var1) throws SuperException, IOException;

    @Override
    public FileDigestSignResult signPdf(String accountId) {
        FileDigestSignResult fileDigestSignResult = new FileDigestSignResult();
        try {
            Precondition.checkSignParam(this.Js);
            this.a(this.Js);
            this.Jv = this.a(this.Jg, accountId);
            this.Ju.setSignServiceId(this.Jv.getSignServiceId());
            byte[] byArray = this.cT(accountId);
            this.uI();
            this.a(this.Jg, accountId, byArray, this.Jv.getSignServiceId(), this.Jv.isNeedWillId());
            this.a(byArray, fileDigestSignResult);
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, FileDigestSignResult.class);
        }
        catch (Exception exception) {
            LOGGER.error("sign pdf failed.", (Throwable)exception);
            return ResultUtil.failed(10000, exception.getMessage(), true, FileDigestSignResult.class);
        }
        fileDigestSignResult.setSignServiceId(this.Jv.getSignServiceId());
        fileDigestSignResult.setAuthId(this.Jv.getAuthId());
        return fileDigestSignResult;
    }

    protected CreateSignDetailResult a(AbstractServiceClient abstractServiceClient, String string) throws SuperException {
        return b.a(abstractServiceClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] cT(String string) throws SuperException {
        LOGGER.debug("sign begin: {}", (Object)System.currentTimeMillis());
        Precondition.checkSignParam(this.Jt.getSignType(), this.Jt.getSignPos());
        this.cS(string);
        e e2 = this.b(this.Js);
        e2.l(this.uH());
        try {
            if (e2.xp() != 0) {
                throw ErrorsDiscriptor.PdfSigningCreateStampFailed.e();
            }
            byte[] byArray = e2.xy();
            String string2 = DigestUtil.sha256Digest(byArray);
            LOGGER.debug("sign call: {}", (Object)System.currentTimeMillis());
            int n2 = this.Ju.sign(string, string2, this.Ju.getCode());
            AssertSupport.assertTrue(0 == n2, ErrorsDiscriptor.PdfSign.e(n2));
            e2.r(this.Ju.signature(), string2);
            byte[] byArray2 = e2.xu();
            return byArray2;
        }
        finally {
            e2.xl();
            LOGGER.debug("sign end: {}", (Object)System.currentTimeMillis());
        }
    }

    private List<h> uH() throws SuperException {
        ArrayList<h> arrayList = new ArrayList<h>();
        SignType signType = this.Jt.getSignType();
        for (PosBean posBean : this.Jt.getSignPos()) {
            h h2 = new h();
            h2.g(posBean.getPosX());
            h2.h(posBean.getPosY());
            h2.dh(posBean.getCoordinateValueType().type());
            h2.df(posBean.getCoordinateReferencePointStrategy().type());
            h2.dg(posBean.getSignatureReferencePointStrategy().type());
            h2.cR(posBean.getPosPage());
            h2.cU(signType.val());
            h2.setAddSignTime(posBean.isAddSignTime());
            h2.dL(this.uF());
            h2.dm(posBean.getKeyWord());
            com.timevale.tgpdfsign.b.a a2 = h2.yc().wO().wN();
            if (SignType.Edges.equals((Object)signType)) {
                if (posBean.isEdgePosXAdjust()) {
                    h2.de(EdgePosXAdjustType.ADJUST.getType());
                }
                h2.o(0.0f);
            }
            a2.setHeight(this.b(posBean));
            a2.setWidth(this.a(posBean));
            a2.setData(this.Jt.getSealData());
            if (posBean.getTimeX() != null || posBean.getTimeY() != null) {
                g g2 = new g();
                g2.setType(DescriptionType.TEXT.getType());
                g2.l(posBean.getTimeY() == null ? 0.0f : posBean.getTimeY().floatValue());
                g2.k(posBean.getTimeX() == null ? 0.0f : posBean.getTimeX().floatValue());
                g2.dp(posBean.getPosPage());
                g2.j(10.0f);
                g2.cV(1);
                g2.setDescription(TimeFormatUtil.dateTimeToString(new Date()));
                ArrayList<g> arrayList2 = new ArrayList<g>();
                arrayList2.add(g2);
                h2.o(arrayList2);
            }
            arrayList.add(h2);
        }
        return arrayList;
    }

    private void uI() throws SuperException {
    }

    protected void a(AbstractServiceClient abstractServiceClient, String string, byte[] byArray, String string2, boolean bl2) throws SuperException {
        String string3 = DigestUtil.sha256Digest(this.Js.getStream());
        String string4 = DigestUtil.sha256Digest(byArray);
        LOGGER.debug("start save sign log, time={}", (Object)System.currentTimeMillis());
        String string5 = null;
        b.b(abstractServiceClient, string, this.Ju.getDigest(), this.Ju.signature(), this.Js.getFileName(), string5, string2, this.Ju.getIntendSignLogRef(), string3, string4);
        LOGGER.debug("end save sign log, time={}", (Object)System.currentTimeMillis());
    }

    protected e b(SignPDFDocBean signPDFDocBean) throws SuperException {
        e e2 = new e(signPDFDocBean.getOwnerPassword().getBytes());
        if (signPDFDocBean.isStreamMode() ? e2.af(signPDFDocBean.getStream()) != 0 : e2.ds(signPDFDocBean.getSrcFile()) != 0) {
            throw ErrorsDiscriptor.PDF_OPEN_FAILED.e();
        }
        HttpConfig httpConfig = HiddenOperationDelegator.networkConfig(this.uy());
        e2.setProxy(httpConfig.getProxyIp(), httpConfig.getProxyPort());
        return e2;
    }

    private void a(byte[] byArray, FileDigestSignResult fileDigestSignResult) throws SuperException {
        AssertSupport.assertTrue(byArray != null && byArray.length > 0, ErrorsDiscriptor.direct(10000, Jp));
        long l2 = System.currentTimeMillis();
        String string = this.Js.getDstFile();
        if (!StringUtil.isNull(string)) {
            File file = FileRWUtil.createFileIfNotExist(string);
            try {
                FileRWUtil.writeFile(file, byArray);
            }
            catch (IOException iOException) {
                throw ErrorException.convertException(2006);
            }
            fileDigestSignResult.setDstFilePath(file.getAbsolutePath());
        } else {
            fileDigestSignResult.setStream(byArray);
        }
        LOGGER.debug("saveFile cost:{}", (Object)(System.currentTimeMillis() - l2));
    }

    protected AccountInfoResult cU(String string) throws SuperException {
        AccountService accountService = this.uy().accountService();
        AccountInfoResult accountInfoResult = accountService.getAccountInfo(string, false);
        if (!RequestUtil.isRequestSuccess(accountInfoResult)) {
            LOGGER.error("query account name by uid failed. account: {} ", (Object)string);
            throw ErrorsDiscriptor.AccountInfo.e();
        }
        return accountInfoResult;
    }

    protected BufferedImage uJ() throws SuperException {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageUtil.base64ToBufferedImage(this.getSealData());
        }
        catch (Exception exception) {
            LOGGER.error("invalid base64 sealData.", (Throwable)exception);
            throw ErrorsDiscriptor.BadSealImageData.e();
        }
        AssertSupport.assertNotnull(bufferedImage, ErrorsDiscriptor.BadSealImageData.e());
        return bufferedImage;
    }
}

