/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static File createTempFile(String prefix, String suffix, File path) throws IOException {
        if (!path.isDirectory()) {
            return File.createTempFile(prefix, suffix, path.getParentFile());
        }
        return File.createTempFile(prefix, suffix, path);
    }

    public static File createTempFile(String prefix, String suffix, String path) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, new File(path));
    }

    public static byte[] fileToByte(String filePath) throws IOException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n2;
            File file = new File(filePath);
            fileInputStream = new FileInputStream(file);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = fileInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error("get byte error", (Throwable)fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            LOGGER.error("get byte error", (Throwable)iOException);
            throw iOException;
        }
        finally {
            try {
                fileInputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.error("close stream error", (Throwable)iOException);
            }
        }
        return byArray;
    }
}

