/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.tech.sdk.utils.Base64Util;
import esign.utils.Base64;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCutUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCutUtil.class);
    private static int PADDING = 5;

    public static void main(String[] args) throws IOException {
        String string = "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";
        ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(Base64.decode(string))), "png", new FileOutputStream(new File("c:\\tester_org.png")));
        BufferedImage bufferedImage = ImageCutUtil.getCutImage(string, 56, 56);
        ImageIO.write((RenderedImage)bufferedImage, "png", new FileOutputStream(new File("c:\\tester.png")));
    }

    public static BufferedImage getCutImage(String imageBase64, int finalWidth, int finalheight) throws IOException {
        InputStream inputStream = ImageCutUtil.base64ToInputStream(imageBase64);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return ImageCutUtil.cutBufferedImage(bufferedImage, finalWidth, finalheight);
    }

    public static BufferedImage cutBufferedImage(BufferedImage image, int finalWidth, int finalheight) {
        Rectangle rectangle = ImageCutUtil.getCutRectangle(image);
        BufferedImage bufferedImage = ImageCutUtil.cut(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        double d2 = ImageCutUtil.getZoomsize(image, finalWidth, finalheight);
        BufferedImage bufferedImage2 = ImageCutUtil.fitToSize(bufferedImage, (double)finalWidth * d2, (double)finalheight * d2);
        return bufferedImage2;
    }

    private static BufferedImage cut(BufferedImage image, int x2, int y2, int width, int height) {
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("png");
            ImageReader imageReader = iterator.next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(ImageCutUtil.bufferedImageToByteArray(image, "png")));
            imageReader.setInput(imageInputStream, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(x2, y2, width, height);
            imageReadParam.setSourceRegion(rectangle);
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            imageInputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static Rectangle getCutRectangle(BufferedImage image) {
        int n2;
        int n3;
        int n4;
        int n5 = image.getWidth();
        int n6 = image.getHeight();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl2 = false;
        block0: for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = image.getRGB(n4, n3);
                if (n2 >> 24 == 0) continue;
                if (!bl2) {
                    n7 = n4;
                    bl2 = true;
                }
                if (n4 <= n8) continue block0;
                n8 = n4;
                continue block0;
            }
        }
        n4 = 0;
        block2: for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n11 = image.getRGB(n2, n3);
                if (n11 >> 24 == 0) continue;
                if (n4 == 0) {
                    n9 = n3;
                    n4 = 1;
                }
                if (n3 <= n10) continue block2;
                n10 = n3;
                continue block2;
            }
        }
        if (n7 > PADDING) {
            n7 -= PADDING;
        }
        if (n8 < n5 - PADDING) {
            n8 += PADDING;
        }
        if (n9 > PADDING) {
            n9 -= PADDING;
        }
        if (n10 < n5 - PADDING) {
            n10 += PADDING;
        }
        n3 = n8 - n7;
        n2 = n10 - n9;
        Rectangle rectangle = null;
        rectangle = n3 <= 0 || n2 <= 0 ? new Rectangle(0, 0, n5, n6) : new Rectangle(n7, n9, n3, n2);
        return rectangle;
    }

    private static InputStream base64ToInputStream(String base64) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] byArray = Base64Util.decode(base64);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayInputStream;
    }

    private static byte[] bufferedImageToByteArray(BufferedImage bImage, String format) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bImage, format, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static BufferedImage fitToSize(BufferedImage image, double finalWidth1, double finalheight1) {
        int n2 = (int)Math.ceil(finalWidth1);
        int n3 = (int)Math.ceil(finalheight1);
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        int n6 = 0;
        int n7 = 0;
        if (n2 / n4 > n3 / n5) {
            n7 = n3;
            n6 = n4 * n3 / n5;
        } else {
            n6 = n2;
            n7 = n5 * n2 / n4;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n2, n3, 3);
        graphics2D.dispose();
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.drawImage(image.getScaledInstance(n6, n7, 4), (n2 - n6) / 2, (n3 - n7) / 2, null);
        return bufferedImage;
    }

    private static double getZoomsize(BufferedImage bufferedImage, int width, int height) {
        int n2;
        double d2;
        int n3 = bufferedImage.getWidth();
        double d3 = (double)n3 / (double)width;
        return d3 < (d2 = (double)(n2 = bufferedImage.getHeight()) / (double)height) ? d3 : d2;
    }
}

