/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.seal.sdk.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUtil {
    private static Logger LOG = LoggerFactory.getLogger(ValidateUtil.class);
    private static final String EMAIL_REG = "^[a-zA-Z\\d][-\\.\\w]*@(?:[-\\w]+\\.)+(?:[a-zA-Z])+$";
    private static final String ORG_CODE_REG = "^([0-9a-zA-Z]{8}-[0-9a-zA-Z])|([0-9a-zA-Z]{9})$";
    private static final String MOBILE_REG = "^(((13[0-9]{1})|(14[0-9]{1})|(15[0-9]{1})|(16[0-9]{1})|(17[0-9]{1})|(18[0-9]{1})|(19[0-9]{1}))+\\d{8})$";
    private static final String BANK_CARD_REG = "[\\d]{16,19}";
    private static final String REG_CODE_REG = "[\\d]{15}";
    private static final String IDCARD_PRC_15 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
    private static final String IDCARD_PRC_18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|x|X){1}$";
    private static final String IDCARD_TW = "^[a-zA-Z]{1}[12]{1}\\d{8}$";
    private static final String IDCARD_MAC = "^[157]{1}\\d{6}[0-9A-Z]{1}$";
    private static final String IDCARD_HK = "^[A-Z]{1}\\d{6}[0-9A]{1}$";
    private static final String TW_PASSPORD_REG = "^[0-9]{10}|[0-9]{8}$";
    private static final String MAC_PASSPORD_REG = "^[Mm]{1}([0-9]{10}|[0-9]{8})$";
    private static final String HK_PASSPORD_REG = "^[Hh]{1}([0-9]{10}|[0-9]{8})$";
    private static final String FOREIGN_PASSPORT = "[a-zA-Z\\d]{1,25}$";

    public static boolean IdNoValid(String idNo) {
        return ValidateUtil.valid(idNo, IDCARD_PRC_18) || ValidateUtil.valid(idNo, IDCARD_PRC_15);
    }

    public static boolean TWIdNoValid(String idNo) {
        return ValidateUtil.valid(idNo, IDCARD_TW);
    }

    public static boolean MACNoValid(String idNo) {
        return ValidateUtil.valid(idNo, IDCARD_MAC);
    }

    public static boolean HKNoValid(String idNo) {
        return ValidateUtil.valid(idNo, IDCARD_HK);
    }

    public static boolean emailValid(String email) {
        return ValidateUtil.valid(email, EMAIL_REG);
    }

    public static boolean mobileValid(String mobile) {
        return ValidateUtil.valid(mobile, MOBILE_REG);
    }

    public static boolean HKPassValid(String hkPasspord) {
        return ValidateUtil.valid(hkPasspord, HK_PASSPORD_REG);
    }

    public static boolean MACPassValid(String macPasspord) {
        return ValidateUtil.valid(macPasspord, MAC_PASSPORD_REG);
    }

    public static boolean TWPassValid(String twPasspord) {
        return ValidateUtil.valid(twPasspord, TW_PASSPORD_REG);
    }

    public static boolean ForeignPassValid(String foreignPasspord) {
        return ValidateUtil.valid(foreignPasspord, FOREIGN_PASSPORT);
    }

    public static boolean socialValid(String code) {
        return ValidateUtil.socialValid(code, true);
    }

    public static boolean socialValid(String code, boolean crc) {
        try {
            if (!code.equals("") && code.length() == 18) {
                int n2;
                int n3;
                if (Pattern.compile("/^([0-9A-Z]{2})([0-9]{6})([0-9A-Z]){10}$/").matcher(code).matches()) {
                    return false;
                }
                if (!crc) {
                    return true;
                }
                String string = "0123456789ABCDEFGHJKLMNPQRTUWXY";
                char[] cArray = string.toCharArray();
                int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
                int[] nArray2 = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
                char[] cArray2 = code.toCharArray();
                HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
                for (n3 = 0; n3 < code.length(); ++n3) {
                    hashMap.put(Character.valueOf(cArray[n3]), n3);
                }
                n3 = 0;
                for (n2 = 0; n2 < 17; ++n2) {
                    Character c2 = Character.valueOf(cArray2[n2]);
                    int n4 = nArray[string.indexOf(c2.charValue())];
                    int n5 = nArray2[n2];
                    n3 += n4 * n5;
                }
                n2 = 31 - n3 % 31;
                n2 = 31 == n2 ? 0 : n2;
                return n2 == string.indexOf(cArray2[17]);
            }
            return false;
        }
        catch (Exception exception) {
            LOG.error("error to valid businessCode for {}", (Object)code);
            return false;
        }
    }

    public static boolean bankcardValid(String cardno) {
        return StringUtils.isBlank(cardno) ? false : ValidateUtil.valid(cardno, BANK_CARD_REG);
    }

    public static boolean orgBankcardValid(String cardno) {
        if (StringUtils.isBlank(cardno = cardno.trim())) {
            return false;
        }
        return cardno.length() <= 30 && cardno.length() >= 5;
    }

    public static boolean orgCodeValid(String orgCode) {
        return ValidateUtil.valid(orgCode, "^[135789N]{1}[123459]{1}\\d{6}[\\dA-Z]{10}$");
    }

    public static boolean regCodeValid(String regCode) {
        return ValidateUtil.valid(regCode, "^\\d{13}$|^\\d{15}$");
    }

    private static boolean valid(String code, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(code);
        return matcher.matches();
    }

    public static boolean isValidDate(String dateStr, String pattern) {
        boolean bl2 = true;
        SimpleDateFormat simpleDateFormat = StringUtils.isBlank(pattern) ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat(pattern);
        try {
            simpleDateFormat.setLenient(false);
            simpleDateFormat.parse(dateStr);
        }
        catch (ParseException parseException) {
            bl2 = false;
        }
        return bl2;
    }
}

