/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import javax.annotation.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string) {
        return string == null ? "" : string;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(minLength);
        for (int i2 = string.length(); i2 < minLength; ++i2) {
            stringBuilder.append(padChar);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(minLength);
        stringBuilder.append(string);
        for (int i2 = string.length(); i2 < minLength; ++i2) {
            stringBuilder.append(padChar);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, int count) {
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
        StringBuilder stringBuilder = new StringBuilder(string.length() * count);
        for (int i2 = 0; i2 < count; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

